#include "rtwindow.h"
#include "rtcontrol.h"
#include "ui_rtwindow.h"
#include "ui_toppanel.h"
#include "ui_bottompanel.h"
#include "dlgeditsw.h"
#include "dlgdumprange.h"
#include "pause_set_dialog.h"
#include "device/rtconfig.h"
#include <QPoint>
#include <QMessageBox>
#include <QLineEdit>
#include <QIntValidator>
#include <QDoubleSpinBox>
#include <QStandardItemModel>
#include "device/device.h"
#include "unmuem_struct.h"
#include <device/gost.h>
#include "device/modecode.h"
#include <framework/core/ISDConfig.h>
#include "framework/gui/actions.h"
#include "framework/gui/centrals.h"

inline uem::device::Device& dev() { return uem::device::Device::instance(); }
inline uem::device::Config& conf() { return dev().config(); }

using namespace gost;

template<> SDWindow* cast_as(RtWindow* x) { return x; }

void createWindow(RtWindow **o, ISDEquip *e)
{
	*o = new RtWindow(e);
}

void destroyWindow(RtWindow *o)
{
	delete o;
}

// Эти константы должны отражать позицию действия в комбобоксе выбора действия
static const int
	IDX_DBCA = 0,
	IDX_SWB_SAV = 1,
	IDX_LCMD_DW = 2,
	IDX_BTMT = 3,
	IDX_DBTMT = 4,
	IDX_BRTF = 5,
	IDX_DBRTF = 6;

RtWindow::RtWindow() :
    SDWindow(nullptr),
	LBITS_NR(32),
    ui(new Ui::RtWindow),
    uitp(new Ui::TopPanel),
    uibp(new Ui::BottomPanel)
{
    ui->setupUi(this);
    uitp->setupUi(ui->topPanel);
    uibp->setupUi(ui->bottomPanel);
    connect(ui->btnEditSW, SIGNAL(clicked(bool)), this, SLOT(editSW(bool)));
}

RtWindow::RtWindow(ISDEquip *e) : 
    SDWindow(e),
	LBITS_NR(32),
    ui(new Ui::RtWindow),
    uitp(new Ui::TopPanel),
    uibp(new Ui::BottomPanel),
	mc_dis_state(conf().common.mc_dis),
	rt_brcst_dis(conf().common.rt_brcst_dis),
	currentItem(NULL),
	rootItem(new QTreeWidgetItem()),
	recvItem(new SATreeWidgetItem(rootItem, QStringList("Прием"))),
	recvItemAdd(new QTreeWidgetItem(recvItem, QStringList("Добавить..."))),
	sendItem(new SATreeWidgetItem(rootItem, QStringList("Передача"))),
	sendItemAdd(new QTreeWidgetItem(sendItem, QStringList("Добавить..."))),
	mc00Item(new MCTreeWidgetItem(rootItem, QStringList("КУ для подадреса 0"))),
	mc00ItemAdd(new QTreeWidgetItem(mc00Item, QStringList("Добавить..."))),
	mc31Item(new MCTreeWidgetItem(rootItem, QStringList("КУ для подадреса 31"))),
	mc31ItemAdd(new QTreeWidgetItem(mc31Item, QStringList("Добавить..."))),
	comboIndex(-1),
	m_min_pqnr(0),
	resp_tout(0),
	npad(NULL),
	np_flags(0),
	lbits(NULL),
	edit_sw(false),
	entries_nr(0)
{
    ui->setupUi(this);
    uitp->setupUi(ui->topPanel);
    uibp->setupUi(ui->bottomPanel);

	bool dump = false;
	for (auto s : QApplication::arguments()) {
		if (s == "--dump")
			dump = true;
	}
	if (!dump)
		uibp->btnDump->hide();
	else
		connect(uibp->btnDump, SIGNAL(clicked()), this, SLOT(showDumpRangeDlg()));

	ui->wgPwEdit->rt_mode();

	ui->hexEditor->setAutoResizeMode(HexEditor::ReflectGreaterBufferLength);
	npad = new BigNumPad(ui->bt_WC_set, LBITS_NR, 8, this);

	ui->splitter->setStretchFactor(1, 4);
	ui->splitter->setStretchFactor(3, 4);

	isde = dynamic_cast< ISDEquipImpl<RtConfig, RtControl, RtWindow> *>(e);
	if (!isde)
		throw std::bad_cast();
	rtc = isde->cf();
	rtcontrol = isde->hc();

	QString rtn(rtc ? QString::number(rtc->rtNumber()) : QString("X"));
	setWindowTitle("ОУ " + rtn);
	rootItem->setText(0, "ОУ " + rtn);
	ui->treeWidget->addTopLevelItem(rootItem);

	cbDiffer0031Toggled(rtc->differ00and31mc);
	ui->cbDiffer0031->setChecked(rtc->differ00and31mc);
	uitp->comstart_cb->setChecked(rtc->common_start);
	uitp->rtnr_edt->setValue(rtc->rtNumber());

	connect(ui->treeWidget, SIGNAL(itemDoubleClicked(QTreeWidgetItem *, int)), this, SLOT(navItemDoubleClicked(QTreeWidgetItem *, int)));
	connect(ui->treeWidget, SIGNAL(currentItemChanged(QTreeWidgetItem *, QTreeWidgetItem *)), this, SLOT(currentItemChanged(QTreeWidgetItem *, QTreeWidgetItem *)));
	connect(ui->btnAdd, SIGNAL(clicked()), this, SLOT(btnAddClicked()));
	connect(ui->btnConfAll, SIGNAL(clicked()), this, SLOT(btnConfAllClicked()));
	connect(ui->btnDelete, SIGNAL(clicked()), this, SLOT(btnDeleteClicked()));
	connect(ui->cbDiffer0031, SIGNAL(toggled(bool)), this, SLOT(cbDiffer0031Toggled(bool)));
    connect(ui->btnEditSW, SIGNAL(clicked(bool)), this, SLOT(editSW(bool)));
	connect(uitp->rtnr_edt, SIGNAL(valueEdited(int)), this, SLOT(rtNumChanged(int)));
	connect(uitp->comstart_cb, SIGNAL(stateChanged(int)), this, SLOT(comstartStateChanged(int)));
	connect(&conf().common, SIGNAL(was_saved()), this, SLOT(updateGUI()));

	//ciDepList.append(ui->dbca_bcstart_cb);
	ciDepList.append(ui->legal_table_gb);
	ciDepList.append(ui->rw_tab);
	//ciDepList.append(ui->n_swb_sav_cb);
	//ciDepList.append(ui->dbca_cb);
	//ciDepList.append(ui->dbca_bcstart_cb);
	ciDepList.append(ui->lcmd_dw_cb);
	//ciDepList.append(ui->wrong_ch_cb);
	

	connect(ui->com_illegal_cb, SIGNAL(toggled(bool)), this, SLOT(ci_toggled(bool)));
	connect(ui->sw_dis_cb, SIGNAL(toggled(bool)), this, SLOT(sw_dis_toggled(bool)));
	connect(ui->wrong_ch_cb, SIGNAL(toggled(bool)), this, SLOT(wrong_ch_toggled(bool)));
	connect(ui->n_swb_sav_cb, SIGNAL(toggled(bool)), this, SLOT(n_swb_sav_toggled(bool)));

	connect(ui->dbca_cb, SIGNAL(toggled(bool)), this, SLOT(dbca_toggled(bool)));
	connect(ui->lcmd_dw_cb, SIGNAL(toggled(bool)), this, SLOT(lcmd_dw_toggled(bool)));
	connect(ui->dbca_bcstart_cb, SIGNAL(toggled(bool)), this, SLOT(dbca_bcstart_toggled(bool)));
	connect(ui->wa_cb, SIGNAL(toggled(bool)), this, SLOT(wa_toggled(bool)));
	connect(ui->brwarx_cb, SIGNAL(toggled(bool)), this, SLOT(brwarx_toggled(bool)));
	connect(ui->rb_WC_exactly, SIGNAL(toggled(bool)), ui->le_WC_exactly, SLOT(setEnabled(bool)));
	connect(ui->rb_WC_from, SIGNAL(toggled(bool)), ui->le_WC_from, SLOT(setEnabled(bool)));
	connect(ui->rb_WC_from, SIGNAL(toggled(bool)), ui->le_WC_to, SLOT(setEnabled(bool)));
	connect(ui->rb_WC_given, SIGNAL(toggled(bool)), ui->bt_WC_set, SLOT(setEnabled(bool)));
	connect(ui->dw_cou_cb, SIGNAL(toggled(bool)), this, SLOT(dw_cou_cb_toggled(bool)));
	connect(ui->dw_cou_ne, SIGNAL(valueEdited(int)), this, SLOT(dw_cou_ne_changed(int)));
	connect(ui->dw_cou_ne, SIGNAL(editingFinished()), this, SLOT(dw_cou_edFin()));
	connect(ui->hexEditor, SIGNAL(editingFinished()), this, SLOT(editingFinished()));

#define DISABLE_EDIT_TIME 1
#if DISABLE_EDIT_TIME
	if (!rtc->min_pqnr_common)
	{
		rtc->min_pqnr_common = true;
		rtc->min_pqnr = conf().common.min_pqnr;
		rtc->set_modified();
	}
	if (!rtc->resp_tout_common)
	{
		rtc->resp_tout_common = true;
		rtc->resp_tout = conf().common.resp_tout;
		rtc->set_modified();
	}
	ui->min_pqnr_cb->setEnabled(false);
	ui->resp_tout_cb->setEnabled(false);
#endif

	if (rtc->min_pqnr_common)
		m_min_pqnr = conf().common.min_pqnr;
	else
		m_min_pqnr = rtc->min_pqnr;

	if (rtc->resp_tout_common)
		resp_tout = conf().common.resp_tout;
	else
		resp_tout = rtc->resp_tout;

	ui->min_pqnr_sb->setValue(0.25 * m_min_pqnr);
	ui->resp_tout_sb->setValue(resp_tout);
	ui->pause_set_sb->setValue(0.25 * rtc->resp_pause);

#if !DISABLE_EDIT_TIME
	connect(ui->min_pqnr_cb, &QCheckBox::toggled, [=](bool checked) {
		ui->min_pqnr_sb->setDisabled(checked);
		comCfgToggled(checked, ui->min_pqnr_cb);
		rtc->min_pqnr_common = checked;
	});
	connect(ui->resp_tout_cb, &QCheckBox::toggled, [=](bool checked) {
		ui->resp_tout_sb->setDisabled(checked);
		comCfgToggled(checked, ui->resp_tout_cb);
		rtc->resp_tout_common = checked;
	});
	connect(ui->min_pqnr_sb, &QAbstractSpinBox::editingFinished, [=]() {
		m_min_pqnr = ui->min_pqnr_sb->value() / 0.25;
		rtc->min_pqnr = m_min_pqnr;
	});
	connect(ui->resp_tout_sb, &QAbstractSpinBox::editingFinished, [=]() {
		resp_tout = ui->resp_tout_sb->value();
		rtc->resp_tout = resp_tout;
	});
#endif
	connect(ui->pause_set_btn, SIGNAL(clicked(bool)), this, SLOT(pause_set_btn_clicked()));

	connect(ui->bt_WC_set, SIGNAL(clicked()), this, SLOT(restoreNPad()));
	connect(npad, SIGNAL(flagsChanged()), this, SLOT(nPadChanged()));

	QIntValidator *v;
	v = new QIntValidator();
	v->setTop(32);
	v->setBottom(1);
	ui->le_WC_exactly->setValidator(v);
	ui->le_WC_from->setValidator(v);
	ui->le_WC_to->setValidator(v);
	connect(ui->le_WC_exactly, SIGNAL(editingFinished()), this, SLOT(editingFinished()));
	connect(ui->le_WC_from, SIGNAL(editingFinished()), this, SLOT(editingFinished()));
	connect(ui->le_WC_to, SIGNAL(editingFinished()), this, SLOT(editingFinished()));
	connect(ui->rb_WC_any, SIGNAL(toggled(bool)), this, SLOT(ltrb_toggled(bool)));
	connect(ui->rb_WC_exactly, SIGNAL(toggled(bool)), this, SLOT(ltrb_toggled(bool)));
	connect(ui->rb_WC_from, SIGNAL(toggled(bool)), this, SLOT(ltrb_toggled(bool)));
	connect(ui->rb_WC_given, SIGNAL(toggled(bool)), this, SLOT(ltrb_toggled(bool)));
	unsigned int i = 0;
	rootItem->setExpanded(true);
	for (i = 0; i < (uint)rootItem->childCount(); i++)
		rootItem->child(i)->setExpanded(true);

	restoreResponsies(DlgNewNavItem::RECV, rtc->responsies.data);
	restoreResponsies(DlgNewNavItem::MC00, rtc->mc00responsies.data);
	if (!rtc->differ00and31mc)
		mc00Item->setText(0, "КУ для подадресов 0 и 31");
	if (rtc->mc31responsies != nullptr) {
		restoreResponsies(DlgNewNavItem::MC31, rtc->mc31responsies->data);
	}

	lbits = new bool[LBITS_NR];
	memset(lbits, 0, LBITS_NR);

	connect(ui->hexEditor, SIGNAL(wordClick(size_t, int, int)), this, SLOT(wordClick(size_t, int, int)));
	connect(ui->hexEditor, SIGNAL(focusChanged(bool)), this, SLOT(he_focus_changed(bool)));
	connect(ui->codDataEdit, SIGNAL(valueChanged(quint32)), this, SLOT(codDataChanged(quint32)));
	connect(ui->wgPwEdit, SIGNAL(valueChanged(quint32)), this, SLOT(wgPwChanged(quint32)));
	connect(ui->editSW, SIGNAL(getFocus()), this, SLOT(editSW_got_focus()));
	connect(ui->editSW, SIGNAL(looseFocus()), this, SLOT(editSW_loose_focus()));
	connect(ui->editSW, SIGNAL(textEdited(const QString&)), this, SLOT(editSWvalueEdited(const QString&)));
	connect(ui->btnResetCode, SIGNAL(clicked()), this, SLOT(btnResetCodeClicked()));
	ui->editSW->setStyleSheet("QLineEdit#editSW{color:blue}");

	connect(uibp->btnLoad, SIGNAL(clicked(bool)), ::actions->acLoad, SLOT(trigger()));
	connect(uibp->btnStart, SIGNAL(clicked(bool)), ::actions->acStart, SLOT(trigger()));
	connect(uibp->btnStop, SIGNAL(clicked(bool)), ::actions->acStop, SLOT(trigger()));
	connect(uibp->btnHide, SIGNAL(clicked()), parent(), SLOT(hide()));

	uibp->btnStop->setDisabled(true);
	ui->dw_cou_ne->setMaxValue(62);
	rtc->set_modified(false);

	connect(isde->config(), SIGNAL(modified_changed(bool)), this, SLOT(modified_changed(bool)));
	connect(isde->control(), SIGNAL(loaded_changed(bool)), this, SLOT(loaded_changed(bool)));
	connect(isde->hc(), &RtControl::running_changed,
		[=](bool s) {
			uitp->devStatus_lbl->setText(s ? "<font color='green'>УСТРОЙСТВО РАБОТАЕТ</font>" : "УСТРОЙСТВО ОСТАНОВЛЕНО");
			uibp->btnStart->setEnabled(!s);
			uibp->btnStop->setEnabled(s);
			uitp->rtnr_edt->setEnabled(!s);
		});

	if (rtcontrol) {
		rtcontrol->set_rtWindow(this);
	} else
		printf("ERROR: No RT control!\n");

	adjSize();

	delete recvItemAdd;
	recvItem->SATreeWidgetItem::sortChildren(0, Qt::AscendingOrder);
	recvItemAdd = new QTreeWidgetItem(recvItem, QStringList("Добавить..."));

	delete sendItemAdd;
	sendItem->SATreeWidgetItem::sortChildren(0, Qt::AscendingOrder);
	sendItemAdd = new QTreeWidgetItem(sendItem, QStringList("Добавить..."));

	delete mc00ItemAdd;
	mc00Item->sortChildren(0, Qt::AscendingOrder);
	MCTreeWidgetItem *reserved = cutReservedItems(mc00Item);
	reserved->MCTreeWidgetItem::sortChildren(0, Qt::AscendingOrder);
	pasteReservedItems(mc00Item, reserved);
	mc00ItemAdd = new QTreeWidgetItem(mc00Item, QStringList("Добавить..."));

	delete mc31ItemAdd;
	mc31Item->sortChildren(0, Qt::AscendingOrder);
	reserved = cutReservedItems(mc31Item);
	reserved->MCTreeWidgetItem::sortChildren(0, Qt::AscendingOrder);
	pasteReservedItems(mc31Item, reserved);
	mc31ItemAdd = new QTreeWidgetItem(mc31Item, QStringList("Добавить..."));

	ui->stackedWidget->setCurrentIndex(0);
	ui->bselWgPw->setChecked(true);
	connect(ui->bselCodData, &QPushButton::toggled, [=](bool checked) { ui->stackedWidget->setCurrentIndex((int)checked); } );
}

RtWindow::~RtWindow()
{
	int i = 0, j = 0;
	for (i = 0; i < rootItem->childCount(); i++) {
		if (!rootItem->child(i))
			continue;
		for (j = 0; j < rootItem->child(i)->childCount(); j++) {
			while(rtc->responsies.data.size() > 0) {
				delete rtc->responsies.data.back();
				rtc->responsies.data.pop_back();
			}
		}
	}

	delete []lbits;
    delete uibp;
    delete uitp;
    delete ui;
}

void RtWindow::loaded_changed(bool s)
{
	uitp->confStatus_lbl->setText(s ? "<font color='green'>КОНФИГУРАЦИЯ ЗАГРУЖЕНА</font>" : "<font color='red'>КОНФИГУРАЦИЯ ИЗМЕНЕНА</font>");
	if (s)
		printf("КОНФИГУРАЦИЯ ЗАГРУЖЕНА\n");
	else
		printf("КОНФИГУРАЦИЯ ИЗМЕНЕНА");
	if (!isde->control()->running())
		uibp->btnStart->setEnabled(true);
	printf("-------- loaded_changed(%s)\n", s ? "true" : "false");
	uibp->btnLoad->setEnabled(!s);
}

void RtWindow::modified_changed(bool s)
{
	if (s) {
		uitp->confStatus_lbl->setText("<font color='red'>КОНФИГУРАЦИЯ ИЗМЕНЕНА</font>");
		uibp->btnLoad->setEnabled(s);
		printf("КОНФИГУРАЦИЯ ИЗМЕНЕНА");
	} else if (!isde->config()->modified() && !isde->control()->loaded()) {
		uitp->confStatus_lbl->setText("<font color='black'>КОНФИГУРАЦИЯ СОХРАНЕНА</font>");
		//QMetaObject::invokeMethod(uitp->confStatus_lbl, "setText", Q_ARG(QString, "<font color='black'>КОНФИГУРАЦИЯ СОХРАНЕНА</font>"));
		//uitp->confStatus_lbl->repaint();
		//repaint();
		printf("%s\n", uitp->confStatus_lbl->text().toStdString().c_str());
		//if (entries_nr != 0)
		//	update_rtnr();
	}
	printf("-------- modified_changed(%s)\n", s ? "true" : "false");
}

void RtWindow::showDumpRangeDlg()
{
	if (!rtcontrol->loaded()) {
		QMessageBox::StandardButton reply = QMessageBox::warning(this, "Warning", "Конфигурация выбранного ОУ не загружена.\nПродолжить?", QMessageBox::Yes | QMessageBox::No);
		if (reply == QMessageBox::No)
			return;
	}
	DlgDumpRange *dlg = new DlgDumpRange(this, UNMUEM_RT_SW_START, UNMUEM_RT_DATA_END);
	ViUInt32 a = 0, b = 0;

	int rs = dlg->exec();
	if (rs == QDialog::Accepted) {
		dlg->getRange(a, b);
		isde->hc()->mk_dump(a, b, dlg->isOverall());
	}

	delete dlg;
}

void RtWindow::update_rtnr()
{
	int i, j, nr = rtc->rtNumber();
	QTreeWidgetItem* item = NULL;
	if (!currentItem || !currentItem->parent() || currentItem->parent() == rootItem ||
		currentItem->parent()->child(currentItem->parent()->childCount() - 1) == currentItem)
			return;
	RtResponse r = currentItem->data(0, Qt::UserRole).value<RtResponse>();
	try {
		rbt(r.entry_tag);
	} catch (rt_exception e) {
		QMessageBox::critical(this, "Error", e.what_q());
		return;
	}

	r.entry_tag &= ~(0x1F << 11);
	r.entry_tag |= ((nr & 0x1f) << 11);

	DlgNewNavItem *dlg = new DlgNewNavItem(this);
	for (i = 0; i < rootItem->childCount(); i++) {
		if (!rootItem->child(i))
			continue;
		for (j = 0; j < rootItem->child(i)->childCount() - 1; j++) {
			item = rootItem->child(i)->child(j);
			printf("%s\n", item->text(0).toStdString().c_str());
			RtResponse r = item->data(0, Qt::UserRole).value<RtResponse>();
			r.entry_tag &= ~(0x1F << 11);
			r.entry_tag |= ((nr & 0x1f) << 11);
			item->setData(0, Qt::UserRole, QVariant(QVariant::fromValue(r)));
			if (i > 1)
				item->setText(0, QString("%1-%2-%3-%4 %5").arg((r.entry_tag >> 11) & 0x1f)
						.arg((r.entry_tag >> 10) & 0x1).arg((r.entry_tag >> 5) & 0x1f).arg(r.entry_tag & 0x1f).arg(dlg->getGOSTString(r.entry_tag)));
		}
	}
	delete dlg;

	for (unsigned int i = 0; i < rtc->responsies.data.size(); i++) {
		RtResponse *r = rtc->responsies.data.at(i);
		r->statusword.cod_data_s().b.wb &= ~0xF800;
		r->statusword.cod_data_s().b.wb |= nr << 11;
		r->entry_tag &= ~(0x1F << 11);
		r->entry_tag |= ((nr & 0x1f) << 11);
	}
	for (unsigned int i = 0; i < rtc->mc00responsies.data.size(); i++) {
		RtResponse *r = rtc->mc00responsies.data.at(i);
		r->statusword.cod_data_s().b.wb &= ~0xF800;
		r->statusword.cod_data_s().b.wb |= nr << 11;
		r->entry_tag &= ~(0x1F << 11);
		r->entry_tag |= ((nr & 0x1f) << 11);
	}
	if (rtc->mc31responsies)
		for (unsigned int i = 0; i < rtc->mc31responsies->data.size(); i++) {
			RtResponse *r = rtc->mc31responsies->data.at(i);
			r->statusword.cod_data_s().b.wb &= ~0xF800;
			r->statusword.cod_data_s().b.wb |= nr << 11;
			r->entry_tag &= ~(0x1F << 11);
			r->entry_tag |= ((nr & 0x1f) << 11);
		}

	if (ui->editSW->isEnabled()) {
		ui->codDataEdit->setValue(rbt(r.entry_tag)->statusword.cod_data_s().i);
		ui->editSW->setValue(rbt(r.entry_tag)->statusword.cod_data_s().i & 0xffff);
	}
}

// Next implementation. Temporary in different piece of code
void RtWindow::update_rtnr_2(int old_nr, int nr)
{
	int i, j;
	QTreeWidgetItem* item = NULL;

	DlgNewNavItem *dlg = new DlgNewNavItem(this);
	for (i = 0; i < rootItem->childCount(); i++) {
		if (!rootItem->child(i))
			continue;
		for (j = 0; j < rootItem->child(i)->childCount() - 1; j++) {
			item = rootItem->child(i)->child(j);
			printf("%s\n", item->text(0).toStdString().c_str());
			RtResponse r = item->data(0, Qt::UserRole).value<RtResponse>();
			r.entry_tag &= ~(0x1F << 11);
			r.entry_tag |= ((nr & 0x1f) << 11);
			item->setData(0, Qt::UserRole, QVariant(QVariant::fromValue(r)));
			if (i > 1)
				item->setText(0, QString("%1-%2-%3-%4 %5").arg((r.entry_tag >> 11) & 0x1f)
						.arg((r.entry_tag >> 10) & 0x1).arg((r.entry_tag >> 5) & 0x1f).arg(r.entry_tag & 0x1f).arg(dlg->getGOSTString(r.entry_tag)));
		}
	}
	delete dlg;

	for (unsigned int i = 0; i < rtc->responsies.data.size(); i++) {
		RtResponse *r = rtc->responsies.data.at(i);
		StatusWord sw (r->statusword.cod_data_s().b.wb);
		if (sw.rt == old_nr)
		{
			sw.rt = nr;
			r->statusword.cod_data_s().b.wb = sw.asword();
		}
		r->entry_tag &= ~(0x1F << 11);
		r->entry_tag |= ((nr & 0x1f) << 11);
	}
	for (unsigned int i = 0; i < rtc->mc00responsies.data.size(); i++) {
		RtResponse *r = rtc->mc00responsies.data.at(i);
		StatusWord sw (r->statusword.cod_data_s().b.wb);
		if (sw.rt == old_nr)
		{
			sw.rt = nr;
			r->statusword.cod_data_s().b.wb = sw.asword();
		}
		r->entry_tag &= ~(0x1F << 11);
		r->entry_tag |= ((nr & 0x1f) << 11);
	}
	if (rtc->mc31responsies)
		for (unsigned int i = 0; i < rtc->mc31responsies->data.size(); i++) {
			RtResponse *r = rtc->mc31responsies->data.at(i);
			StatusWord sw (r->statusword.cod_data_s().b.wb);
			if (sw.rt == old_nr)
			{
				sw.rt = nr;
				r->statusword.cod_data_s().b.wb = sw.asword();
			}
			r->entry_tag &= ~(0x1F << 11);
			r->entry_tag |= ((nr & 0x1f) << 11);
		}

	if (!currentItem || !currentItem->parent() || currentItem->parent() == rootItem ||
		currentItem->parent()->child(currentItem->parent()->childCount() - 1) == currentItem)
			return;

	RtResponse r = currentItem->data(0, Qt::UserRole).value<RtResponse>();
	try {
		rbt(r.entry_tag);
	} catch (rt_exception e) {
		QMessageBox::critical(this, "Error", e.what_q());
		return;
	}

	//r.entry_tag &= ~(0x1F << 11);
	//r.entry_tag |= ((nr & 0x1f) << 11);

	if (ui->editSW->isEnabled()) {
		ui->codDataEdit->setValue(rbt(r.entry_tag)->statusword.cod_data_s().i);
		ui->editSW->setValue(rbt(r.entry_tag)->statusword.cod_data_s().i & 0xffff);
	}
}

void RtWindow::config_state_changed()
{
	bool ac = false;

	printf("config_state_changed\n");
	if (isde->config()->modified()) {
		ac = true;
		printf("MODIFIED\n");
	}
	if (isde->control()->loaded()) {
		ac = true;
		printf("LOADED\n");
	}
	if (!ac)
		printf("SAVED?\n");
}

void RtWindow::editSW_got_focus()
{
	RtResponse r = currentItem->data(0, Qt::UserRole).value<RtResponse>();
	try {
		rbt(r.entry_tag);
	} catch (rt_exception e) {
		QMessageBox::critical(this, "Error", e.what_q());
		return;
	}

	ui->wnr_lb->setText("");
	ui->lbWord->setText("Ответное слово");
	ui->codDataEdit->setEnabled(true);
	ui->wgPwEdit->setEnabled(true);

	ui->codDataEdit->setValue(rbt(r.entry_tag)->statusword.cod_data_s().i);
	ui->wgPwEdit->setValue(rbt(r.entry_tag)->statusword.wg_pw_s().i);

	ui->btnResetCode->setEnabled(true);
	edit_sw = true;
}

void RtWindow::editSWvalueEdited(const QString& str)
{
	bool ok;

	quint64 val = str.toULongLong(&ok, 16);
	editSWvalueEdited(val);
}

void RtWindow::editSWvalueEdited(qint64 val)
{
	RtResponse r = currentItem->data(0, Qt::UserRole).value<RtResponse>();
	try {
		rbt(r.entry_tag)->statusword.cod_data_s().b.wb = val;
		ui->codDataEdit->setValue(rbt(r.entry_tag)->statusword.cod_data_s().i);
	} catch (rt_exception e) {
		QMessageBox::critical(this, "Error", e.what_q());
		return;
	}
	printf("RtWindow::editSWvalueEdited(%llu)\n", val);
	rtc->set_modified(true);
}

void RtWindow::editSW_loose_focus()
{
}

void RtWindow::reset_wgword(uem::device::wgword& wgword, bool dataWord)
{
	wgword.wg_pw_s().b.word_pause = 1;
	wgword.wg_pw_s().b.ch_b_a = 0;
	wgword.wg_pw_s().b.cou_aact = 0;
	wgword.wg_pw_s().b.cou_esync = 0;
	wgword.wg_pw_s().b.cou_start_end_ = dataWord;
	wgword.wg_pw_s().b.gap_lim = 0;
	if (dataWord) {
		wgword.wg_pw_s().b.gap = 0;
	} else {
		wgword.wg_pw_s().b.gap = set_silence(); //m_min_pqnr;// + resp_tout) >> 1;

		wgword.cod_data_s().b.wb = rtc->rtNumber() << 11;
		printf("rtc->rtNumber = %d, sw = %X\n", rtc->rtNumber(), wgword.cod_data_s().i);
	}

	wgword.cod_data_s().b.c_d = dataWord ? 0 : 1;
	wgword.cod_data_s().b.et = 0;
	wgword.cod_data_s().b.bn = 0;
	wgword.cod_data_s().b.el = 0;
}

void RtWindow::btnResetCodeClicked()
{
	RtResponse *response = NULL;
	RtResponse r = currentItem->data(0, Qt::UserRole).value<RtResponse>();
	quint32 data = ui->codDataEdit->value() & 0xffff;

	try {
		response = rbt(r.entry_tag);
	} catch (rt_exception e) {
		QMessageBox::critical(this, "Error", e.what_q());
		return;
	}

	ui->codDataEdit->setValue(data);
	ui->wgPwEdit->setValue(0);

	if (edit_sw) {
		response->statusword.init();
		response->statusword.cod_data_s().b.wb = data;
		reset_wgword(response->statusword, false);
		ui->wgPwEdit->setValue(response->statusword.wg_pw);
		ui->editSW->setStyleSheet("QLineEdit#editSW{color:blue}");
	} else {
		response->datawords.at(ui->hexEditor->lastClickedWordNR() - 1).init();
		response->datawords.at(ui->hexEditor->lastClickedWordNR() - 1).cod_data_s().b.wb = data;
		reset_wgword(response->datawords.at(ui->hexEditor->lastClickedWordNR() - 1), true);
		ui->hexEditor->selectWordWithColor(ui->hexEditor->lastClickedWordNR() - 1, Qt::blue);
		ui->hexEditor->update();
	}
	rtc->set_modified(true);
}

bool RtWindow::test_sw_c9s(unmuem_cod_data_t *val)
{
	if (!val)
		return false;
	if (val->b.c_d == 1 &&
		val->b.et == 0 &&
		val->b.bn == 0 &&
		val->b.el == 0) {
		return true;
	}
#if 1
	printf("cod_data.b.c_d = %x\n", val->b.c_d);
	printf("cod_data.b.et = %x\n", val->b.et);
	printf("cod_data.b.bn = %x\n", val->b.bn);
	printf("cod_data.b.el = %x\n", val->b.el);
#endif
	return false;		
}

bool RtWindow::test_sw_c9s(unmuem_wg_pw_t *val)
{
	if (!val)
		return false;
	if (val->b.word_pause == 1 && val->b.cou_alt_same_ == 0 && val->b.cou_aact == 0 &&
		val->b.ch_b_a == 0 && val->b.cou_esync == 0 && val->b.cou_start_end_ == 0 &&
		val->b.gap_lim == 0 && ((val->b.gap >= min_silence() /*m_min_pqnr*//* >> 2*/) && (val->b.gap <= resp_tout*4))) {
			return true;
	}
#if 1
	printf("wg_pw.b.word_pause = %x\n", val->b.word_pause);
	printf("wg_pw.b.ch_b_a = %x\n", val->b.ch_b_a);
	printf("wg_pw.b.cou_aact = %x\n", val->b.cou_aact);
	printf("wg_pw.b.cou_alt_same_ = %x\n", val->b.cou_alt_same_);
	printf("wg_pw.b.cou_esync = %x\n", val->b.cou_esync);
	printf("wg_pw.b.cou_start_end_ = %x\n", val->b.cou_start_end_);
	printf("wg_pw.b.gap_lim = %x\n", val->b.gap_lim);
	printf("wg_pw.b.gap = %x(%d)\n", val->b.gap, val->b.gap);
	//printf("m_min_pqnr / 4 = %.2f, resp_tout = %d\n", m_min_pqnr / 4.0, resp_tout);
	printf("min_silence / 4 = %.2f, resp_tout = %d\n", min_silence() / 4.0, resp_tout);
#endif
	return false;
}

bool RtWindow::test_dw_c9s(unmuem_cod_data_t *val)
{
	if (!val)
		return false;
	if (val->b.c_d == 0 &&
		val->b.et == 0 &&
		val->b.bn == 0 &&
		val->b.el == 0) {
			return true;
	}
#if 1
	printf("cod_data.b.c_d = %x\n", val->b.c_d);
	printf("cod_data.b.et = %x\n", val->b.et);
	printf("cod_data.b.bn = %x\n", val->b.bn);
	printf("cod_data.b.el = %x\n", val->b.el);
#endif
	return false;
}

bool RtWindow::test_dw_c9s(unmuem_wg_pw_t *val)
{
	if (!val)
		return false;
	if (val->b.word_pause == 1 && val->b.cou_alt_same_ == 0 && val->b.cou_aact == 0 &&
		val->b.ch_b_a == 0 && val->b.cou_esync == 0 && val->b.cou_start_end_ == 1 &&
		val->b.gap_lim == 0 && val->b.gap == 0) {
			return true;
	}
#if 1
	printf("wg_pw.b.word_pause = %x\n", val->b.word_pause);
	printf("wg_pw.b.ch_b_a = %x\n", val->b.ch_b_a);
	printf("wg_pw.b.cou_aact = %x\n", val->b.cou_aact);
	printf("wg_pw.b.cou_alt_same_ = %x\n", val->b.cou_alt_same_);
	printf("wg_pw.b.cou_esync = %x\n", val->b.cou_esync);
	printf("wg_pw.b.cou_start_end_ = %x\n", val->b.cou_start_end_);
	printf("wg_pw.b.gap_lim = %x\n", val->b.gap_lim);
	printf("wg_pw.b.gap = %x\n", val->b.gap);
	printf("4 * m_min_pqnr = %d, resp_tout = %d\n", 4 * m_min_pqnr, resp_tout);
#endif
	return false;
}

template <class Type> bool RtWindow::testi_c9s(bool focusOnSW, ViUInt32 i)
{
	Type v;
	v.i = i;
	if (focusOnSW)
		return test_sw_c9s(&v);
	else
		return test_dw_c9s(&v);
}

void RtWindow::codDataChanged(quint32 val)
{
	RtResponse r = currentItem->data(0, Qt::UserRole).value<RtResponse>();
	unmuem_cod_data_t cd_tmp;
	bool fail = false;

	cd_tmp.i = val;
	try {
		if (edit_sw) {
			rbt(r.entry_tag)->statusword.cod_data_s().i = val;
			ui->editSW->setValue(val & 0xffff);
			if (!test_sw_c9s(&cd_tmp)) {
				ui->editSW->setStyleSheet("QLineEdit#editSW{color:red}");
				printf("test_sw_c9s(&cd_tmp) FAILED\n");
				fail = true;
			}
			unmuem_wg_pw_t wg_pw_tmp = rbt(r.entry_tag)->statusword.wg_pw_s();
			if (!test_sw_c9s(&wg_pw_tmp)) {
				ui->editSW->setStyleSheet("QLineEdit#editSW{color:red}");
				printf("test_sw_c9s(&wg_pw_tmp) FAILED on 0x%x\n", wg_pw_tmp.i);
			} else if (!fail) {
				ui->editSW->setStyleSheet("QLineEdit#editSW{color:blue}");
				printf("test_sw_c9s(&cod_data_tmp) OK on 0x%x\n", cd_tmp.i);
				printf("test_sw_c9s(&wg_pw_tmp) OK on 0x%x\n", wg_pw_tmp.i);
			}
		} else {
			rbt(r.entry_tag)->datawords.at(ui->hexEditor->lastClickedWordNR() - 1).cod_data_s().i = val;
			he_data[currentItem]->data()[ui->hexEditor->lastClickedWordNR() - 1] = val & 0xffff;
			if (!test_dw_c9s(&cd_tmp)) {
				ui->hexEditor->selectWordWithColor(ui->hexEditor->lastClickedWordNR() - 1, Qt::red);
				printf("test_dw_c9s(&cd_tmp) FAILED\n");
				fail = true;
			}
			unmuem_wg_pw_t wg_pw_tmp = rbt(r.entry_tag)->datawords.at(ui->hexEditor->lastClickedWordNR() - 1).wg_pw_s();
			if (!test_dw_c9s(&wg_pw_tmp)) {
				ui->hexEditor->selectWordWithColor(ui->hexEditor->lastClickedWordNR() - 1, Qt::red);
				printf("test_dw_c9s(&wg_pw_tmp) FAILED on 0x%x\n", wg_pw_tmp.i);
			} else if (!fail) {
				ui->hexEditor->selectWordWithColor(ui->hexEditor->lastClickedWordNR() - 1, Qt::blue);
				printf("test_dw_c9s(&cod_data_tmp) OK on 0x%x\n", cd_tmp.i);
				printf("test_dw_c9s(&wg_pw_tmp) OK on 0x%x\n", wg_pw_tmp.i);
			}
		}
	} catch (rt_exception e) {
		QMessageBox::critical(this, "Error", e.what_q());
		return;
	}
	ui->codDataEdit->disconnect();
	ui->hexEditor->update();
	connect(ui->codDataEdit, SIGNAL(valueChanged(quint32)), this, SLOT(codDataChanged(quint32)));
	rtc->set_modified();
}

void RtWindow::wgPwChanged(quint32 val)
{
	RtResponse r = currentItem->data(0, Qt::UserRole).value<RtResponse>();
	RtResponse *response = NULL;

	try {
		response = rbt(r.entry_tag);
	} catch (rt_exception e) {
		QMessageBox::critical(this, "Error", e.what_q());
		return;
	}

	printf("wgPwChanged %X\n", val);
	unmuem_wg_pw_t wg_pw_tmp;
	wg_pw_tmp.i = val;
	bool fail = false;

	wg_pw_tmp.b.word_pause = 1;
	val = wg_pw_tmp.i;
	printf("wgPwChanged with corrected value %X\n", val);

	if (edit_sw) {
		response->statusword.wg_pw_s().i = val;
		printf("wg_pw_s().i = 0x%x\n", val);
		if(!test_sw_c9s(&wg_pw_tmp)) {
			ui->editSW->setStyleSheet("QLineEdit#editSW{color:red}");
			printf("test_sw_c9s(&wg_pw_tmp) FAILED\n");
			fail = true;
		}
		unmuem_cod_data_t cod_data_tmp = response->statusword.cod_data_s();
		if (!test_sw_c9s(&cod_data_tmp)) {
			ui->editSW->setStyleSheet("QLineEdit#editSW{color:red}");
			printf("test_sw_c9s(&cod_data_tmp) FAILED on 0x%x\n", cod_data_tmp.i);
		} else if (!fail) {
			ui->editSW->setStyleSheet("QLineEdit#editSW{color:blue}");
			printf("test_sw_c9s(&cod_data_tmp) OK on 0x%x\n", cod_data_tmp.i);
			printf("test_sw_c9s(&wg_pw_tmp) OK on 0x%x\n", wg_pw_tmp.i);
		}
	} else {
		response->datawords.at(ui->hexEditor->lastClickedWordNR() - 1).wg_pw_s().i = val;
		printf("wg_pw_s().i = 0x%x\n", val);
		if(!test_dw_c9s(&wg_pw_tmp)) {
			ui->hexEditor->selectWordWithColor(ui->hexEditor->lastClickedWordNR() - 1, Qt::red);
			printf("test_dw_c9s(&wg_pw_tmp) FAILED\n");
			fail = true;
		}
		unmuem_cod_data_t cod_data_tmp = response->datawords.at(ui->hexEditor->lastClickedWordNR() - 1).cod_data_s();
		if (!test_dw_c9s(&cod_data_tmp)) {
			ui->hexEditor->selectWordWithColor(ui->hexEditor->lastClickedWordNR() - 1, Qt::red);
			printf("test_dw_c9s(&cod_data_tmp) FAILED on 0x%x\n", cod_data_tmp.i);
		} else if (!fail) {
			ui->hexEditor->selectWordWithColor(ui->hexEditor->lastClickedWordNR() - 1, Qt::blue);
			printf("test_dw_c9s(&cod_data_tmp) OK on 0x%x\n", cod_data_tmp.i);
			printf("test_dw_c9s(&wg_pw_tmp) OK on 0x%x\n", wg_pw_tmp.i);
		}
	}
	rtc->set_modified();
	ui->hexEditor->update();
}

void RtWindow::he_focus_changed(bool s)
{
	if (s && he_data[currentItem] && ui->hexEditor->lastClickedWordNR() - 1 < he_data[currentItem]->size()) {
		ui->hexEditor->wordClick(ui->hexEditor->lastClickedWordNR() - 1, 0, 0);
	}
}

void RtWindow::wordClick(size_t n, int x, int y)
{
	RtResponse r = currentItem->data(0, Qt::UserRole).value<RtResponse>();
	RtResponse *response = NULL;
	try {
		response = rbt(r.entry_tag);
	} catch (rt_exception e) {
		QMessageBox::critical(this, "Error", e.what_q());
		return;
	}

	ui->lbWord->setText("Слово данных");
	if (!he_data[currentItem]->size()) {
		ui->codDataEdit->setEnabled(false);
		ui->wgPwEdit->setEnabled(false);
		ui->codDataEdit->setValue(0);
		ui->wnr_lb->setText("N / A");
		ui->btnResetCode->setEnabled(false);
		return;
	}

	printf("hexEditor->isModified() == %d\n", ui->hexEditor->isModified());
	printf("ui->hexEditor->lastClickedWordNR() == %li; n == %lu\n", ui->hexEditor->lastClickedWordNR(), n);
	edit_sw = false;

	if (!ui->hexEditor->isModified() && he_data[currentItem] && n < he_data[currentItem]->size()) {
		printf("word N %lu was clicked at (x=%d; y=%d)\n", n, x, y);
	}
	ui->codDataEdit->setEnabled(true);
	ui->wgPwEdit->setEnabled(true);
	ui->btnResetCode->setEnabled(true);
	ui->wnr_lb->setText(QString("N %1").arg(n));
	printf("DATA: 0x%X\n", he_data[currentItem]->data()[n]);

	response->datawords.at(n).cod_data_s().b.wb = he_data[currentItem]->data()[n];
	ui->codDataEdit->setValue(response->datawords.at(n).cod_data_s().i);
	ui->wgPwEdit->setValue(response->datawords.at(n).wg_pw_s().i);
	printf("setting value: %x\n", response->datawords.at(n).cod_data_s().i);
}

void RtWindow::restoreNPad()
{
	QPoint coord = ui->bt_WC_set->pos();
    coord.ry() += ui->bt_WC_set->size().height();
	coord = ui->bt_WC_set->parentWidget()->mapToGlobal(coord);
    npad->move(coord);
  	npad->restore(lbits);
}

void RtWindow::nPadChanged()
{
	np_flags = 0;
	for (int i = 0; i < 32; i++) {
		if (lbits[i])
			np_flags |= 1 << i;
	};
	np_flags = ~np_flags;
	printf("RtWindow::nPadChanged(): legal_table = 0x%x\n", np_flags);
	set_legal_table(legal_table::SET, np_flags);
	rtc->set_modified();
}

void RtWindow::ltrb_toggled(bool s)
{
	if (s)
		editingFinished();
}

void RtWindow::editingFinished()
{
	QObject* w = sender();
	QLineEdit* le = qobject_cast<QLineEdit *>(w);;
	QRadioButton* rb = qobject_cast<QRadioButton *>(w);
	HexEditor* hedit = qobject_cast<HexEditor *>(w);

	if(le) {
		if (le == ui->le_WC_exactly)
			set_legal_table(legal_table::EXACTLY, ui->le_WC_exactly->text().toInt());
		else if (le == ui->le_WC_from || le == ui->le_WC_to) {
			set_legal_table(legal_table::FROMTO, ui->le_WC_from->text().toInt() << 16 | ui->le_WC_to->text().toInt());
		}
	} else if (rb) {
		if (rb == ui->rb_WC_any)
			set_legal_table(legal_table::ANY, 0);
		else if (rb == ui->rb_WC_given) {
			set_legal_table(legal_table::SET, np_flags);
		} else if (rb == ui->rb_WC_exactly)
			set_legal_table(legal_table::EXACTLY, ui->le_WC_exactly->text().toInt());
		else if (rb == ui->rb_WC_from) {
			set_legal_table(legal_table::FROMTO, ui->le_WC_from->text().toInt() << 16 | ui->le_WC_to->text().toInt());
		}
	} else if (hedit) {
		RtResponse r = currentItem->data(0, Qt::UserRole).value<RtResponse>();
		RtResponse *response = NULL;
		try {
			response = rbt(r.entry_tag);
		} catch (rt_exception e) {
			QMessageBox::critical(this, "Error", e.what_q());
			return;
		}

		if (ui->hexEditor->isModified()) {
			for (size_t i = 0; i < response->datawords.size(); i++)
				response->datawords.at(i).cod_data_s().b.wb = he_data[currentItem]->data()[i];
			ui->hexEditor->setModified(false);
		}
		auto n = ui->hexEditor->lastClickedWordNR() - 1;
		ui->codDataEdit->setValue(response->datawords.at(n).cod_data_s().i);
	}

	printf("editing finished rb=%p le=%p\n", rb, le);
	rtc->set_modified();
}

void RtWindow::restoreResponsies(int to, std::vector<uem::device::RtResponse *>& data)
{
	RtResponse r;
	QTreeWidgetItem *sp = NULL;

	DlgNewNavItem *dlg = new DlgNewNavItem(this);
	for (unsigned int i = 0; i < data.size(); i++) {
		entries_nr++;
		r.entry_tag = data.at(i)->entry_tag;
		r.statusword.wg_pw = data.at(i)->statusword.wg_pw;
		r.statusword.cod_data = data.at(i)->statusword.cod_data;
		r.rt_des = data.at(i)->rt_des;
		r.datawords.insert(r.datawords.end(), data.at(i)->datawords.begin(), data.at(i)->datawords.end());
		r.legal_table = data.at(i)->legal_table;
		switch (to) {
			case DlgNewNavItem::RECV:
			case DlgNewNavItem::SEND:
				sp = new SATreeWidgetItem((SATreeWidgetItem *)NULL, QStringList(QString("ПА %1").arg((r.entry_tag >> 5) & 0x1f)));
				rootItem->child((r.entry_tag >> 10) & 0x1)->insertChild(rootItem->child((r.entry_tag >> 10) & 0x1)->childCount() - 1, sp);
				break;
			case DlgNewNavItem::MC00:
				sp = new MCTreeWidgetItem((MCTreeWidgetItem *)NULL, QStringList(QString("%1-%2-%3-%4 %5").arg((r.entry_tag >> 11) & 0x1f)
						.arg((r.entry_tag >> 10) & 0x1).arg((r.entry_tag >> 5) & 0x1f).arg(r.entry_tag & 0x1f).arg(dlg->getGOSTString(r.entry_tag))));
				rootItem->child(2)->insertChild(rootItem->child(2)->childCount() - 1, sp);
				break;
			case DlgNewNavItem::MC31:
				sp = new MCTreeWidgetItem((MCTreeWidgetItem *)NULL, QStringList(QString("%1-%2-%3-%4 %5").arg((r.entry_tag >> 11) & 0x1f)
						.arg((r.entry_tag >> 10) & 0x1).arg((r.entry_tag >> 5) & 0x1f).arg(r.entry_tag & 0x1f).arg(dlg->getGOSTString(r.entry_tag))));
				rootItem->child(3)->insertChild(rootItem->child(3)->childCount() - 1, sp);
				if (!rtc->differ00and31mc)
					rootItem->child(3)->setHidden(true);
				break;
			case DlgNewNavItem::MC00N31:
				printf("BAD_BAD_BAD\n");
			default:
				printf("ERROR: inconsistent target\n");
		};
		sp->setToolTip(0, sp->text(0));
		sp->setData(0, Qt::UserRole, QVariant(QVariant::fromValue(r)));
		printf("%04Xh) rt  = %d\n", r.entry_tag, (r.entry_tag >> 11) & 0x1f);
		printf("%04Xh) tx  = %d\n", r.entry_tag, (r.entry_tag >> 10) & 0x1);
		printf("%04Xh) sa  = %d\n", r.entry_tag, (r.entry_tag >> 5) & 0x1f);
		printf("%04Xh) ndw = %d\n", r.entry_tag, r.entry_tag & 0x1f);

		int dw_size = data.at(i)->datawords.size();
		DataWords* w = new DataWords(dw_size);
		for (int j = 0; j < dw_size; j++) {
			w->data()[j] = data.at(i)->datawords.at(j).cod_data_s().b.wb;
		}
		ui->hexEditor->setBuffer(w->data(), dw_size);
		he_data[sp] = w;
	}
	delete dlg;
	updateGUI();
}

void RtWindow::currentItemChanged(QTreeWidgetItem *current, QTreeWidgetItem *)
{
	QTreeWidgetItem *p = current->parent();
//	currentItem = reinterpret_cast<SATreeWidgetItem *>(current);
	currentItem = current;
	bool status = rtc->modified();
	bool loaded = rtcontrol->loaded();
	bool loadBtnEnabled = uibp->btnLoad->isEnabled();
	RtResponse r = currentItem->data(0, Qt::UserRole).value<RtResponse>();
	RtResponse *response = NULL;

	bool is_mc = p == mc00Item || p == mc31Item;

	printf(">>>>> modified = %s; loaded = %d, comboIndex = %d\n", status ? "true" : "false", loaded, comboIndex);
	QString cfgStatus = uitp->confStatus_lbl->text();
	reset_rtdes_tab();
	if (current->childCount() > 0 || p->indexOfChild(current) == p->childCount() - 1) {
		ui->tabWidget->setEnabled(false);
		ui->btnDelete->setEnabled(false);
		return;
	} else {
		ui->tabWidget->setEnabled(true);
		ui->btnDelete->setEnabled(true);
	}
	printf("\ncurrent item changed (entry_tag = %X)\n", r.entry_tag);
	try {
		response = rbt(r.entry_tag);
	} catch (rt_exception e) {
		QMessageBox::critical(this, "Error", e.what_q());
		return;
	}

	disconnect(isde->config(), SIGNAL(modified_changed(bool)), this, SLOT(modified_changed(bool)));
	disconnect(isde->control(), SIGNAL(loaded_changed(bool)), this, SLOT(loaded_changed(bool)));
	ui->sw_dis_cb->setChecked(unmuem::as<unmuem_rt_des_t>(response->rt_des).b.sw_dis);
	ui->com_illegal_cb->setChecked(unmuem::as<unmuem_rt_des_t>(response->rt_des).b.com_illegal);
	ui->wrong_ch_cb->setChecked(unmuem::as<unmuem_rt_des_t>(response->rt_des).b.wrong_ch);
	ui->n_swb_sav_cb->setChecked(! unmuem::as<unmuem_rt_des_t>(response->rt_des).b.swb_sav);
	ui->dbca_cb->setChecked(unmuem::as<unmuem_rt_des_t>(response->rt_des).b.dbca);
	ui->dbca_bcstart_cb->setChecked(unmuem::as<unmuem_rt_des_t>(response->rt_des).b.dbca_bcstart);
	ui->lcmd_dw_cb->setChecked(unmuem::as<unmuem_rt_des_t>(response->rt_des).b.lcmd_dw);
	ui->wa_cb->blockSignals(true);
	ui->wa_cb->setChecked(unmuem::as<unmuem_rt_des_t>(response->rt_des).b.wa);
	ui->wa_cb->blockSignals(false);
	ui->brwarx_cb->setChecked(response->brwarx);
	ci_toggled(unmuem::as<unmuem_rt_des_t>(response->rt_des).b.com_illegal);
	sw_dis_toggled(unmuem::as<unmuem_rt_des_t>(response->rt_des).b.sw_dis);

	if (unmuem::as<unmuem_rt_des_t>(response->rt_des).b.dw_cou == 0x3f) {
		ui->dw_cou_ne->setValue(legal_ndw(current));
		ui->dw_cou_cb->setChecked(true);
		ui->dw_cou_ne->setEnabled(false);
	} else {
		ui->dw_cou_ne->setValue(unmuem::as<unmuem_rt_des_t>(response->rt_des).b.dw_cou);
		ui->dw_cou_cb->setChecked(false);
		ui->dw_cou_ne->setEnabled(true);
	}
	ui->dw_cou_cb->setEnabled(!(
		unmuem::as<unmuem_rt_des_t>(response->rt_des).b.lcmd_dw ||
		unmuem::as<unmuem_rt_des_t>(response->rt_des).b.dbca));

	for (int i = 0; i < 32; i++) {
		lbits[i] = true;
	};
	legal_table::TBL_TYPE t = response->legal_table.get_type();
	switch (t) {
	case legal_table::ANY:
		ui->rb_WC_any->setChecked(true);
		break;
	case legal_table::EXACTLY:
		ui->le_WC_exactly->setText(QString::number(response->legal_table.get_value(t)));
		ui->rb_WC_exactly->setChecked(true);
		break;
	case legal_table::TO:
	case legal_table::FROM:
	case legal_table::FROMTO:
		ui->le_WC_from->setText(QString::number(response->legal_table.get_value(legal_table::FROM)));
		ui->le_WC_to->setText(QString::number(response->legal_table.get_value(legal_table::TO)));
		ui->rb_WC_from->setChecked(true);
		break;
	case legal_table::SET:
		np_flags = response->legal_table.get_value(legal_table::SET);
		ui->rb_WC_given->setChecked(true);
		printf("------ legal_table SET  0x%x\n", np_flags);
		for (int i = 0; i < 32; i++) {
			if (np_flags & 1 << i)
				lbits[i] = false;
			else
				lbits[i] = true;
		};
		break;
	}

	if (he_data[currentItem]) {
		unsigned int n = response->datawords.size();
		printf("he_data[currentItem] = %p\nhe_data[currentItem]->data() = %p\n", he_data[currentItem], he_data[currentItem]->data());
		ui->hexEditor->setBuffer(NULL, 0);
		printf("resizing to %d words\n", n);
		he_data[currentItem]->resize(n);
		printf("SETTING HEXEDITOR BUFFER in item %p:\n", (void *)currentItem);
		for (unsigned int i = 0; i < he_data[currentItem]->size(); i++) {
			he_data[currentItem]->data()[i] = response->datawords.at(i).cod_data_s().b.wb;
		}
		ui->hexEditor->setBuffer(he_data[currentItem]->data(), n/*he_data[currentItem]->size()*/);
		ui->hexEditor->setReadonly(false);
		ui->dw_cou_ne->setValue(n);

		printf("setting hexEditor read/write\n");
		for (unsigned int i = 0; i < n; i++) {
			if (!testi_c9s<unmuem_cod_data_t>(false /*edit_sw*/, response->datawords.at(i).cod_data_s().i) ||
				!testi_c9s<unmuem_wg_pw_t>(false /*edit_sw*/, response->datawords.at(i).wg_pw_s().i))
				ui->hexEditor->selectWordWithColor(i, Qt::red);
		}
	} else {
		ui->hexEditor->setBuffer(NULL, 0);
		printf("setting hexEditor read only\n");
		ui->hexEditor->setReadonly(true);
	}
	QString wordNrString("N ");
	if (he_data[currentItem] && he_data[currentItem]->size()) {
		ui->hexEditor->setCursorAtHead();
		wordNrString += QString::number(ui->hexEditor->lastClickedWordNR() - 1);
		ui->codDataEdit->setValue(response->datawords.at(ui->hexEditor->lastClickedWordNR() - 1).cod_data_s().i);
		printf("he_data[currentItem]->size() == %lu\n", he_data[currentItem]->size());
	} else {
		wordNrString += "/ A";
		ui->btnResetCode->setEnabled(false);
		ui->codDataEdit->setEnabled(false);
		ui->wgPwEdit->setEnabled(false);
		ui->codDataEdit->setValue(0);
		ui->wgPwEdit->setValue(0);
	}
	ui->wnr_lb->setText(wordNrString);
	ui->editSW->setValue(response->statusword.cod_data_s().b.wb);
	if (!test_sw_c9s(&response->statusword.cod_data_s()) || !test_sw_c9s(&response->statusword.wg_pw_s()))
		ui->editSW->setStyleSheet("QLineEdit#editSW{color:red}");
	else
		ui->editSW->setStyleSheet("QLineEdit#editSW{color:blue}");

	uitp->confStatus_lbl->setText(cfgStatus);
	uibp->btnLoad->setEnabled(loadBtnEnabled);
	ui->editSW->setFocus(Qt::MouseFocusReason);
//	if (status)
	rtc->set_modified(status);
	/*
	if (loaded)
		rtcontrol->load();
	*/
	printf("<<<<< modified = %s; loaded = %d\n", status ? "true" : "false", loaded);
	printf("\ncurrent item changed (entry_tag = %X)\n", r.entry_tag);
	connect(isde->config(), SIGNAL(modified_changed(bool)), this, SLOT(modified_changed(bool)));
	connect(isde->control(), SIGNAL(loaded_changed(bool)), this, SLOT(loaded_changed(bool)));

	ui->legal_table_gb->setEnabled(!is_mc & !ui->com_illegal_cb->isChecked());
}

void RtWindow::btnAddClicked()
{
	QTreeWidgetItem *p = NULL;

	if (currentItem && currentItem->childCount() == 0)
		p = currentItem;
	addNavItem(p, 0);
}

void RtWindow::btnConfAllClicked()
{
	int ret = QMessageBox::warning(this, "Внимание!", "В конфигурацию будут добавлены все допустимые ПА и КУ.\nПродолжить?", QMessageBox::Ok | QMessageBox::Cancel);
	switch (ret) {
		case QMessageBox::Ok:
			printf("Configuring all elements...\n");
			addNavItem(NULL, 0xadda11);
//			ui->btnConfAll->setDisabled(true);
			break;
		case QMessageBox::Cancel:
		default:
			break;
	}
}

void RtWindow::navItemDoubleClicked(QTreeWidgetItem *item, int)
{
	if (item->childCount() > 0 || item->parent()->indexOfChild(item) != item->parent()->childCount() - 1)
		return;
	addNavItem(item, 0);
}

bool RtWindow::checkItemBusy(DlgNewNavItem *dlg, DlgNewNavItem::Status *itemStat, QTreeWidgetItem *endpoint, int i, int shift)
{
	RtResponse r;
	bool fail = false;
	int look4;

	if (!endpoint)
		return true;

	dlg->setEmiter(endpoint);
	for(int j = 0; j < endpoint->childCount() - 1; j++) {
		r = endpoint->child(j)->data(0, Qt::UserRole).value<RtResponse>();
		look4 = (r.entry_tag >> shift) & 0x1f;
		printf("looking for (%d =? %d) && TX == 0x%x\n", i, look4, (r.entry_tag & 0x400) >> 10);
		if ((look4 == i) && ((r.entry_tag & 0x400) >> 10 == itemStat->b.tx)) {
			printf("SA = %d with TX = %d is already exist\n", i, itemStat->b.tx);
			fail = true;
			break;
		} else {
			printf("OK, %d != %d, %d != %d\n", look4, i, (r.entry_tag & 0x400) >> 10, itemStat->b.tx);
		}
	}
	return fail;
}

void RtWindow::addNavItem(QTreeWidgetItem *item, int initAll)
{
	qRegisterMetaType<RtResponse>();
	QTreeWidgetItem *sp = NULL;
	int rs;
	RtResponse r;

	if (item) {
		sp = item->parent();
		if (!sp || (sp && !sp->parent()))
			return;
		printf("%s\n", item->parent()->text(0).toStdString().c_str());
	}

	DlgNewNavItem *dlg = new DlgNewNavItem(this);
	if (!dlg)
		return;

	if (initAll) {
		DlgNewNavItem::Status itemStat;
		int pa_a, pa_b;


		if (mc_dis_state) {
			pa_a = 0;
			pa_b = 31;
		} else {
			pa_a = 1;
			pa_b = 30;
		}

		for (int i = pa_a; i < pa_b + 1; i++) {
			itemStat.i = 0;
			itemStat.b.type = DlgNewNavItem::RECV;
			itemStat.b.sa = i;
			itemStat.b.tx = 0;
			if (!checkItemBusy(dlg, &itemStat, recvItem, i, 5))
				doAddNavItem(dlg, &itemStat);

			itemStat.i = 0;
			itemStat.b.type = DlgNewNavItem::SEND;
			itemStat.b.sa = i;
			itemStat.b.tx = 1;
			if (!checkItemBusy(dlg, &itemStat, sendItem, i, 5))
				doAddNavItem(dlg, &itemStat);
		}
		if (!mc_dis_state) {
			itemStat.i = 0;
			for (int i = 0; i < 22; i++) {
				if (i > 8 && i < 16)
					continue;
				itemStat.i = 0;
				itemStat.b.type = DlgNewNavItem::MC00;
				itemStat.b.cmd = i;
				itemStat.b.tx = (i == 17 || i > 19) ? 0 : 1;
				if (!checkItemBusy(dlg, &itemStat, mc00Item, i, 0))
					doAddNavItem(dlg, &itemStat);
				if (rtc->differ00and31mc) {
					itemStat.b.type = DlgNewNavItem::MC31;
					if (!checkItemBusy(dlg, &itemStat, mc31Item, i, 0))
						doAddNavItem(dlg, &itemStat);
				}
			}
		}
	} else {
		dlg->setEmiter(sp);
		QPoint coord = ui->btnAdd->pos();
		coord = ui->btnAdd->parentWidget()->mapToGlobal(coord);
		dlg->move(coord);
		rs = dlg->exec();
		if (rs == QDialog::Accepted) {
			DlgNewNavItem::Status itemStat = dlg->getStat();
			doAddNavItem(dlg, &itemStat);
		}
	}
	delete dlg;
}

void RtWindow::doAddNavItem(DlgNewNavItem *dlg, DlgNewNavItem::Status *itemStat)
{
	RtResponse *response = NULL;
	QTreeWidgetItem *sp = NULL;
	DataWords *w = NULL;
	int n = 0, v = 1;

	reset_rtdes_tab();
	response = new RtResponse;
	if (!response)
		return;
	response->init();

	if (itemStat->b.type == DlgNewNavItem::SEND || itemStat->b.type == DlgNewNavItem::RECV) {
		sp = new SATreeWidgetItem((QTreeWidgetItem *)NULL, QStringList(QString("ПА %1").arg(itemStat->b.sa)));
		response->entry_tag = gost::CW(rtc->rtNumber(), itemStat->b.tx, itemStat->b.sa, 0);
		printf("ADDED TAG TO DATA SEND/RECIEVE TAG = 0x%x; TYPE = %d\n", response->entry_tag, itemStat->b.type);
	} else {
		response->entry_tag = gost::CW(rtc->rtNumber(), itemStat->b.tx, itemStat->b.sa, itemStat->b.cmd);
		sp = new MCTreeWidgetItem((QTreeWidgetItem *)NULL,
			QStringList(QString("%1-%2-%3-%4 %5").arg(rtc->rtNumber()).arg(itemStat->b.tx).arg(itemStat->b.sa).arg(itemStat->b.cmd).arg(dlg->getGOSTString(response->entry_tag))));
		printf("ADDED TAG TO DATA MC TAG = 0x%x; TYPE = %d\n", response->entry_tag, itemStat->b.type);
	}
	currentItem = sp;

	sp->setToolTip(0, sp->text(0));
	printf("itemStat->b.tx = %d\n", itemStat->b.tx);
	sp->setData(0, Qt::UserRole, QVariant(QVariant::fromValue(*response)));
	reset_wgword(response->statusword, false);
	printf("\n\nSTATUSWORD = %X\n", response->statusword.cod_data_s().i);
	switch (itemStat->b.type) {
		case DlgNewNavItem::SEND:
		case DlgNewNavItem::RECV:
			rtc->responsies.data.push_back(response);
			break;
		case DlgNewNavItem::MC00:
		case DlgNewNavItem::MC00N31:
			rtc->mc00responsies.data.push_back(response);
			break;
		case DlgNewNavItem::MC31:
			if (rtc->mc31responsies == nullptr) {
				rtc->mc31responsies = new uem::device::RtResponseTable;
				rtc->mc31responsies->init();
			}
			rtc->mc31responsies->data.push_back(response);
			break;
	};

	dlg->getEndpoint()->insertChild(dlg->getEndpoint()->childCount() - 1, sp);

	set_rtdes_val(DW_COU, 0x3f);
	v = legal_ndw(sp);
	w = new DataWords(v);
	ui->hexEditor->setBuffer(w->data(), v);
	he_data[sp] = w;
	uem::device::wgword wgword;
	wgword.init();
	reset_wgword(wgword, true);
	for (unsigned int i = 0; i < w->size(); i++) {
		response->datawords.push_back(wgword);
	}
	if (v > 0)
		ui->hexEditor->setReadonly(false);

	if (itemStat->b.type == DlgNewNavItem::RECV) {
		recvItemAdd->setText(0, "Я");
		recvItem->sortChildren(0, Qt::AscendingOrder);
		recvItemAdd->setText(0, "Добавить...");
	} else if (itemStat->b.type == DlgNewNavItem::SEND) {
		sendItemAdd->setText(0, "Я");
		sendItem->SATreeWidgetItem::sortChildren(0, Qt::AscendingOrder);
		sendItemAdd->setText(0, "Добавить...");
	} else {
		n = itemStat->b.cmd;
		printf("n = %d\n", n);
		unmuem_rt_des_t &rtdes = response->rt_des_s();
		rtdes.i = 0;
		rtdes.b.swb_sav = 1;
		if (n == 18) rtdes.b.lcmd_dw = 1;
		switch (itemStat->b.type) {
			case DlgNewNavItem::MC00:
			case DlgNewNavItem::MC00N31:
				mc00ItemAdd->setText(0, "Я");
				break;
			case DlgNewNavItem::MC31:
				mc31ItemAdd->setText(0, "Я");
				break;
		}
		dlg->getEndpoint()->sortChildren(0, Qt::AscendingOrder);
		MCTreeWidgetItem *reserved = cutReservedItems(dlg->getEndpoint());
		printf("sorting reserved items...\n");
		reserved->MCTreeWidgetItem::sortChildren(0, Qt::AscendingOrder);
		pasteReservedItems(dlg->getEndpoint(), reserved);
		switch (itemStat->b.type) {
			case DlgNewNavItem::MC00:
			case DlgNewNavItem::MC00N31:
				mc00ItemAdd->setText(0, "Добавить...");
				break;
			case DlgNewNavItem::MC31:
				mc31ItemAdd->setText(0, "Добавить...");
				break;
		}
	}

	ui->dw_cou_ne->setValue(v);
	ui->dw_cou_ne->setEnabled(false);
	ui->dw_cou_cb->setChecked(true);

	ui->treeWidget->setCurrentItem(sp);
	ui->n_swb_sav_cb->setChecked(false);

	ui->editSW->setFocus(Qt::MouseFocusReason);
	dlg->getEndpoint()->setExpanded(true);
	dlg->getEndpoint()->parent()->setExpanded(true);
	entries_nr++;
	rtc->set_modified();
}

MCTreeWidgetItem* RtWindow::cutReservedItems(QTreeWidgetItem *endpoint)
{
	MCTreeWidgetItem* reserved = new MCTreeWidgetItem();
	unsigned i = 0, ndw = 0, tx, children_nr = endpoint->childCount();

	printf("endpoint->childCount() = %d\n", children_nr);
	while (i < children_nr) {
		RtResponse r = endpoint->child(i)->data(0, Qt::UserRole).value<RtResponse>();
		tx = (r.entry_tag >> 10) & 0x1;
		ndw = r.entry_tag & 0x1f;
		const modecode::Info *mi = modecode::find(ndw);

		if (!mi || tx != mi->tir) {
			reserved->addChild(endpoint->takeChild(i));
			children_nr--;
		} else
			i++;
	}
	return reserved;
}

void RtWindow::pasteReservedItems(QTreeWidgetItem *endpoint, MCTreeWidgetItem *reserved)
{
	int children_nr = reserved->childCount(), i = 0;

	printf("reserved->childCount() = %d\n", children_nr);
	while (i++ < children_nr) {
		RtResponse r = reserved->child(0)->data(0, Qt::UserRole).value<RtResponse>();
		unsigned ndw = r.entry_tag & 0x1f;
		endpoint->addChild(reserved->takeChild(0));
		printf("move back %d\n", ndw);
	}
	delete reserved;
}

void RtWindow::btnDeleteClicked()
{
	QTreeWidgetItem *p = currentItem->parent();
	RtResponse r;
	int look4;

	if (currentItem->childCount() > 0 || p->indexOfChild(currentItem) == p->childCount() - 1)
		return;

	r = currentItem->data(0, Qt::UserRole).value<RtResponse>();
	if (currentItem->parent() == sendItem || currentItem->parent() == recvItem) {
		int tx = (r.entry_tag >> 10) & 0x1;
		look4 = (r.entry_tag >> 5) & 0x1f;
		auto it = rtc->responsies.data.begin();

		for (; it != rtc->responsies.data.end(); ++it) {
			if ((((*it)->entry_tag >> 5) & 0x1f) == look4 && tx == (((*it)->entry_tag >> 10) & 0x1))
				break;
		}
		if (it != rtc->responsies.data.end()) {
			rtc->responsies.data.erase(it);
		}
	} else {
		int mctype = (r.entry_tag >> 5) & 0x1f;
		look4 = r.entry_tag & 0x1f;
		int tx = (r.entry_tag >> 10) & 0x1;
		if (mctype) {
			auto it = rtc->mc31responsies->data.begin();

			for (; it != rtc->mc31responsies->data.end(); ++it) {
				if ((((*it)->entry_tag >> 5) & 0x1f) == mctype  && look4 == ((*it)->entry_tag & 0x1f) && tx == (((*it)->entry_tag >> 10) & 0x1))
					break;
			}
			if (it != rtc->mc31responsies->data.end()) {
				rtc->mc31responsies->data.erase(it);
			}
		} else {
			auto it = rtc->mc00responsies.data.begin();

			for (; it != rtc->mc00responsies.data.end(); ++it) {
				if ((((*it)->entry_tag >> 5) & 0x1f) == mctype && look4 == ((*it)->entry_tag & 0x1f) && tx == (((*it)->entry_tag >> 10) & 0x1))
					break;
			}
			if (it != rtc->mc00responsies.data.end()) {
				rtc->mc00responsies.data.erase(it);
			}
		}
	}

	delete he_data[currentItem];
	p->removeChild(currentItem);
	entries_nr--;
	rtc->set_modified();
//	ui->btnConfAll->setEnabled(true);
}

void RtWindow::editSW(bool)
{
	RtResponse r = currentItem->data(0, Qt::UserRole).value<RtResponse>();

    DlgEditSW *dlg = new DlgEditSW(this);
    QPoint coord = ui->btnEditSW->pos();
	try {
	    dlg->setValue(rbt(r.entry_tag)->statusword.cod_data_s().b.wb);
	} catch (rt_exception e) {
		QMessageBox::critical(this, "Error", e.what());
		delete dlg;
		return;
	}
    coord.ry() += ui->btnEditSW->size().height();
	coord = ui->btnEditSW->parentWidget()->mapToGlobal(coord);
    dlg->move(coord);
    int rs = dlg->exec();
    if (rs == QDialog::Accepted)
    {
        ui->editSW->setValue(dlg->value());
		editSWvalueEdited(dlg->value());
		rtc->set_modified(true);
    }
	ui->editSW->setFocus(Qt::MouseFocusReason);
	delete dlg;
}

RtResponse* RtWindow::rbt(gost::word tag, QTreeWidgetItem *ci) throw (rt_exception)
{
	if (!ci) {
		if (!currentItem)
			throw rt_exception("no current item selected");
		else
			ci = currentItem;
	}

	QTreeWidgetItem *p = ci->parent();
	if (!p || p == rootItem) {
		throw rt_exception("no parent found");
	}

	for(std::vector<RtResponse *>::iterator it = rtc->responsies.data.begin();
		it != rtc->responsies.data.end(); ++it)
	{
		if ((*it)->entry_tag == tag)
			return *it;
	}
	for(std::vector<RtResponse *>::iterator it = rtc->mc00responsies.data.begin();
		it != rtc->mc00responsies.data.end(); ++it)
	{
		if ((*it)->entry_tag == tag)
			return *it;
	}
	if (rtc->mc31responsies) {
		for(std::vector<RtResponse *>::iterator it = rtc->mc31responsies->data.begin();
			it != rtc->mc31responsies->data.end(); ++it)
		{
			if ((*it)->entry_tag == tag)
				return *it;
		}
	}

	printf("ERROR: cannot find entry tag 0x%u", tag);
	throw rt_exception(QString("cannot find entry tag 0x%1").arg(tag, 4, 16));
}

RtResponse* RtWindow::currentResponse()
{
	if (!currentItem) return nullptr;
	else
	try {
		RtResponse r = currentItem->data(0, Qt::UserRole).value<RtResponse>();
		return rbt(r.entry_tag);
	} catch (...) {
		return nullptr;
	}
}

void RtWindow::set_legal_table(legal_table::TBL_TYPE t, unsigned v)
{
	RtResponse r = currentItem->data(0, Qt::UserRole).value<RtResponse>();
	if (!rtc) {
		printf("ERROR: no config loaded\n");
		QMessageBox::critical(this, "Error", "no config loaded");
		return;
	}
	printf("something with legal_table; t = %d, v = %u\n", (int)t, v);
	try {
		rbt(r.entry_tag)->legal_table.set_value(t, v);
	} catch (rt_exception e) {
		QMessageBox::critical(this, "Error", e.what());
		return;
	}
	set_rtdes_val(LEGAL_TABLE, (t != legal_table::ANY) && 
		!((t == legal_table::FROMTO) && ((v >> 16) == 1) && ((v & 0xffff) == 32)) &&
//		!((t == legal_table::EXACTLY) && (v == 32)) &&
		!((t == legal_table::SET) && (v == 0)));
}

void RtWindow::set_rtdes_val(enum RTDESBIT bit, int val)
{
	bool status = true;
	if (!currentItem || !currentItem->parent() || currentItem->parent() == rootItem) {
		printf("ERROR: no parent found\n");
		return;
	}
	RtResponse r = currentItem->data(0, Qt::UserRole).value<RtResponse>();

	printf("set_rtdes_val(%d, %d)\n", (int)bit, val);
	try {
		RtResponse *pr = rbt(r.entry_tag);
		if (!pr) return;
		switch (bit) {
		case DW_COU:
			if (unmuem::as<unmuem_rt_des_t>(pr->rt_des).b.dw_cou == val)
				status = false;
			unmuem::as<unmuem_rt_des_t>(pr->rt_des).b.dw_cou = val;
			break;
		case COM_ILLEGAL:
			if (unmuem::as<unmuem_rt_des_t>(pr->rt_des).b.com_illegal == val)
				status = false;
			unmuem::as<unmuem_rt_des_t>(pr->rt_des).b.com_illegal = val;
			break;
		case SW_DIS:
			if (unmuem::as<unmuem_rt_des_t>(pr->rt_des).b.sw_dis == val)
				status = false;
			unmuem::as<unmuem_rt_des_t>(pr->rt_des).b.sw_dis = val;
			break;
		case WRONG_CH:
			if (unmuem::as<unmuem_rt_des_t>(pr->rt_des).b.wrong_ch == val)
				status = false;
			unmuem::as<unmuem_rt_des_t>(pr->rt_des).b.wrong_ch = val;
			break;
		case DBCA:
			if (unmuem::as<unmuem_rt_des_t>(pr->rt_des).b.dbca == val)
				status = false;
			unmuem::as<unmuem_rt_des_t>(pr->rt_des).b.dbca = val;
			break;
		case DBCA_BCSTART:
			if (unmuem::as<unmuem_rt_des_t>(pr->rt_des).b.dbca_bcstart == val)
				status = false;
			unmuem::as<unmuem_rt_des_t>(pr->rt_des).b.dbca_bcstart = val;
			break;
/*
		case BTMT:
			if (unmuem::as<unmuem_rt_des_t>(pr->rt_des).b.btmt == val)
				status = false;
			unmuem::as<unmuem_rt_des_t>(pr->rt_des).b.btmt = val;
			break;
		case DBTMT:
			if (unmuem::as<unmuem_rt_des_t>(pr->rt_des).b.dbtmt == val)
				status = false;
			unmuem::as<unmuem_rt_des_t>(pr->rt_des).b.dbtmt = val;
			break;
		case BRTF:
			if (unmuem::as<unmuem_rt_des_t>(pr->rt_des).b.brtf == val)
				status = false;
			unmuem::as<unmuem_rt_des_t>(pr->rt_des).b.brtf = val;
			break;
		case DBRTF:
			if (unmuem::as<unmuem_rt_des_t>(pr->rt_des).b.dbrtf == val)
				status = false;
			unmuem::as<unmuem_rt_des_t>(pr->rt_des).b.dbrtf = val;
			break;
*/
		case SWB_SAV:
			if (unmuem::as<unmuem_rt_des_t>(pr->rt_des).b.swb_sav == val)
				status = false;
			unmuem::as<unmuem_rt_des_t>(pr->rt_des).b.swb_sav = val;
			break;
		case LCMD_DW:
			if (unmuem::as<unmuem_rt_des_t>(pr->rt_des).b.lcmd_dw == val)
				status = false;
			unmuem::as<unmuem_rt_des_t>(pr->rt_des).b.lcmd_dw = val;
			break;
		case LEGAL_TABLE:
			if (unmuem::as<unmuem_rt_des_t>(pr->rt_des).b.legal_table == val)
				status = false;
			unmuem::as<unmuem_rt_des_t>(pr->rt_des).b.legal_table = val;
			break;
		case WA:
			if (unmuem::as<unmuem_rt_des_t>(pr->rt_des).b.wa == val)
				status = false;
			unmuem::as<unmuem_rt_des_t>(pr->rt_des).b.wa = val;
			break;
		case BRWARX:
			if ((int)pr->brwarx == val)
				status = false;
			pr->brwarx = val;
			break;
		default:
			QMessageBox::critical(this, "Error", QString("ERROR: unknown rt_des bit index %1\n").arg(bit));
			printf("ERROR: unknown rt_des bit index %d\n", bit);
			status = false;
			break;
		}
	} catch (rt_exception e) {
		QMessageBox::critical(this, "Error", e.what());
		status = false;
		return;
	}

//	status |= rtc->modified();
	if (status)
		rtc->set_modified(status);
}

int RtWindow::get_rtdes_val(enum RTDESBIT bit)
{
	if (!currentItem || !currentItem->parent() || currentItem->parent() == rootItem) {
		printf("ERROR: no parent found\n");
		return -1;
	}
	RtResponse r = currentItem->data(0, Qt::UserRole).value<RtResponse>();

	try {
		switch (bit) {
		case DW_COU:
			return unmuem::as<unmuem_rt_des_t>(rbt(r.entry_tag)->rt_des).b.dw_cou;
		case COM_ILLEGAL:
			return unmuem::as<unmuem_rt_des_t>(rbt(r.entry_tag)->rt_des).b.com_illegal;
		case SW_DIS:
			return unmuem::as<unmuem_rt_des_t>(rbt(r.entry_tag)->rt_des).b.sw_dis;
		case WRONG_CH:
			return unmuem::as<unmuem_rt_des_t>(rbt(r.entry_tag)->rt_des).b.wrong_ch;
		case DBCA:
			return unmuem::as<unmuem_rt_des_t>(rbt(r.entry_tag)->rt_des).b.dbca;
		case DBCA_BCSTART:
			return unmuem::as<unmuem_rt_des_t>(rbt(r.entry_tag)->rt_des).b.dbca_bcstart;
/*
		case BTMT:
			return unmuem::as<unmuem_rt_des_t>(rbt(r.entry_tag)->rt_des).b.btmt;
		case DBTMT:
			return unmuem::as<unmuem_rt_des_t>(rbt(r.entry_tag)->rt_des).b.dbtmt;
		case BRTF:
			return unmuem::as<unmuem_rt_des_t>(rbt(r.entry_tag)->rt_des).b.brtf;
		case DBRTF:
			return unmuem::as<unmuem_rt_des_t>(rbt(r.entry_tag)->rt_des).b.dbrtf;
*/
		case SWB_SAV:
			return unmuem::as<unmuem_rt_des_t>(rbt(r.entry_tag)->rt_des).b.swb_sav;
		case LCMD_DW:
			return unmuem::as<unmuem_rt_des_t>(rbt(r.entry_tag)->rt_des).b.lcmd_dw;
		case LEGAL_TABLE:
			return unmuem::as<unmuem_rt_des_t>(rbt(r.entry_tag)->rt_des).b.legal_table;
		case WA:
			return unmuem::as<unmuem_rt_des_t>(rbt(r.entry_tag)->rt_des).b.wa;
			break;
		case BRWARX:
			return rbt(r.entry_tag)->brwarx;
			break;
		default:
			printf("ERROR: unknown rt_des bit index %d\n", bit);
			QMessageBox::critical(this, "Error", QString("ERROR: unknown rt_des bit index %1").arg(bit));
			return -1;
		}
	} catch (rt_exception e) {
		QMessageBox::critical(this, "Error", e.what());
		return -1;
	}
}

void RtWindow::reset_cb(QCheckBox *cb)
{
	cb->setChecked(false);
	cb->setEnabled(true);
}

void RtWindow::reset_rtdes_tab()
{
	ui->sw_dis_cb->disconnect();
	ui->com_illegal_cb->disconnect();
	ui->wrong_ch_cb->disconnect();
	ui->dbca_bcstart_cb->disconnect();
	ui->dbca_cb->disconnect();
	ui->lcmd_dw_cb->disconnect();
	ui->legal_table_gb->disconnect();
	ui->wa_cb->disconnect();
	ui->brwarx_cb->disconnect();
	ui->rb_WC_any->disconnect();
	ui->le_WC_exactly->disconnect();
	ui->le_WC_from->disconnect();
	ui->le_WC_to->disconnect();
	ui->dw_cou_cb->disconnect();
	ui->hexEditor->disconnect();
	ui->codDataEdit->disconnect();
	ui->wgPwEdit->disconnect();
	ui->editSW->disconnect();

	reset_cb(ui->sw_dis_cb);
	reset_cb(ui->com_illegal_cb);
	reset_cb(ui->wrong_ch_cb);
	reset_cb(ui->lcmd_dw_cb);
	reset_cb(ui->dbca_cb);
	reset_cb(ui->dbca_bcstart_cb);
	reset_cb(ui->wa_cb);
	reset_cb(ui->brwarx_cb);
	ui->dbca_bcstart_cb->setDisabled(true);
	ui->legal_table_gb->setEnabled(true);
	ui->rb_WC_any->setChecked(true);
	ui->le_WC_exactly->setText("32");
	ui->le_WC_from->setText("1");
	ui->le_WC_to->setText("32");
	ui->dw_cou_cb->setChecked(false);
	ui->hexEditor->setBuffer(NULL, 0);
	ui->hexEditor->setReadonly(true);
	ui->codDataEdit->setValue(0);
	ui->wgPwEdit->setValue(0);
	ui->editSW->setValue(0);

	connect(ui->com_illegal_cb, SIGNAL(toggled(bool)), this, SLOT(ci_toggled(bool)), Qt::AutoConnection);
	connect(ui->sw_dis_cb, SIGNAL(toggled(bool)), this, SLOT(sw_dis_toggled(bool)), Qt::AutoConnection);
	connect(ui->wrong_ch_cb, SIGNAL(toggled(bool)), this, SLOT(wrong_ch_toggled(bool)), Qt::AutoConnection);
	connect(ui->n_swb_sav_cb, SIGNAL(toggled(bool)), this, SLOT(n_swb_sav_toggled(bool)), Qt::AutoConnection);
	connect(ui->rb_WC_any, SIGNAL(toggled(bool)), this, SLOT(ltrb_toggled(bool)));
	connect(ui->rb_WC_exactly, SIGNAL(toggled(bool)), this, SLOT(ltrb_toggled(bool)));
	connect(ui->rb_WC_from, SIGNAL(toggled(bool)), this, SLOT(ltrb_toggled(bool)));
	connect(ui->rb_WC_given, SIGNAL(toggled(bool)), this, SLOT(ltrb_toggled(bool)));
	connect(ui->le_WC_exactly, SIGNAL(editingFinished()), this, SLOT(editingFinished()), Qt::AutoConnection);
	connect(ui->le_WC_from, SIGNAL(editingFinished()), this, SLOT(editingFinished()), Qt::AutoConnection);
	connect(ui->le_WC_to, SIGNAL(editingFinished()), this, SLOT(editingFinished()), Qt::AutoConnection);
	connect(ui->dbca_cb, SIGNAL(toggled(bool)), this, SLOT(dbca_toggled(bool)), Qt::AutoConnection);
	connect(ui->lcmd_dw_cb, SIGNAL(toggled(bool)), this, SLOT(lcmd_dw_toggled(bool)), Qt::AutoConnection);
	connect(ui->wa_cb, SIGNAL(toggled(bool)), this, SLOT(wa_toggled(bool)), Qt::AutoConnection);
	connect(ui->brwarx_cb, SIGNAL(toggled(bool)), this, SLOT(brwarx_toggled(bool)), Qt::AutoConnection);
	connect(ui->dbca_bcstart_cb, SIGNAL(toggled(bool)), this, SLOT(dbca_bcstart_toggled(bool)), Qt::AutoConnection);
	connect(ui->dw_cou_cb, SIGNAL(toggled(bool)), this, SLOT(dw_cou_cb_toggled(bool)));

	connect(ui->hexEditor, SIGNAL(editingFinished()), this, SLOT(editingFinished()));
	connect(ui->hexEditor, SIGNAL(wordClick(size_t, int, int)), this, SLOT(wordClick(size_t, int, int)));
	connect(ui->hexEditor, SIGNAL(focusChanged(bool)), this, SLOT(he_focus_changed(bool)));
	connect(ui->codDataEdit, SIGNAL(valueChanged(quint32)), this, SLOT(codDataChanged(quint32)));
	connect(ui->wgPwEdit, SIGNAL(valueChanged(quint32)), this, SLOT(wgPwChanged(quint32)));
	connect(ui->editSW, SIGNAL(getFocus()), this, SLOT(editSW_got_focus()));
	connect(ui->editSW, SIGNAL(looseFocus()), this, SLOT(editSW_loose_focus()));
	connect(ui->editSW, SIGNAL(textEdited(const QString&)), this, SLOT(editSWvalueEdited(const QString&)));
}

void RtWindow::wrong_ch_toggled(bool s)
{
	set_rtdes_val(WRONG_CH, s);
}

void RtWindow::n_swb_sav_toggled(bool s)
{
	set_rtdes_val(SWB_SAV, !s);
}

void RtWindow::dw_cou_ne_changed(int k)
{
	printf("dw_cou_ne_changed on %d\n", k);
	ui->codDataEdit->setEnabled(false);
	ui->wgPwEdit->setEnabled(false);
	ui->codDataEdit->setValue(0);
	ui->wgPwEdit->setValue(0);
	ui->wnr_lb->setText("N / A");
	ui->btnResetCode->setEnabled(false);
	dw_cou_ne_modified = true;
	rtc->set_modified();
}

void RtWindow::dw_cou_edFin()
{
	RtResponse r = currentItem->data(0, Qt::UserRole).value<RtResponse>();
	RtResponse *response = NULL;
	unsigned long int old_sz = he_data[currentItem]->size();
	unsigned long int new_sz = ui->dw_cou_ne->value();

	try {
		response = rbt(r.entry_tag);
	} catch (rt_exception e) {
		QMessageBox::critical(this, "Error", e.what());
		return;
	}

	if (!dw_cou_ne_modified || old_sz == new_sz)
		return;

	printf("dw_cou_edFin:\n");
	printf("old size = %lu\n", old_sz);
	printf("new size = %lu\n", new_sz);
	dw_cou_ne_modified = false;
	if (he_data[currentItem]) {
		he_data[currentItem]->resize(new_sz);
		ui->hexEditor->setBuffer(he_data[currentItem]->data(), new_sz);
		ui->hexEditor->setReadonly(false);
	}
	else printf("WRONG THING IS HERE\n");

	response->datawords.resize(new_sz);
	printf("response->datawords resized to %lu elements\n", new_sz);
	if (new_sz > old_sz) {
		for (unsigned int i = old_sz; i < new_sz; i++) {
			response->datawords.at(i).init();
			reset_wgword(response->datawords.at(i), true);
			printf("reseted word N%d\n", i);
		}
	}

	if (new_sz) {
		ui->hexEditor->setCursorAtHead();	
		ui->hexEditor->wordClick(0, 0, 0);
	}
	set_rtdes_val(DW_COU, new_sz);
	printf("set_rtdes_val(DW_COU, %lu)\n", new_sz);
}

void RtWindow::dw_cou_cb_toggled(bool s)
{
	if (!currentItem || currentItem->childCount())
		return;

	RtResponse r = currentItem->data(0, Qt::UserRole).value<RtResponse>();
	RtResponse *response = NULL;
	try {
		response = rbt(r.entry_tag);
	} catch (rt_exception e) {
		QMessageBox::critical(this, "Error", e.what());
		return;
	}

	uint ndw = legal_ndw(currentItem);
	if (s) {
		set_rtdes_val(DW_COU, 0x3f);
		ui->dw_cou_ne->setValue(ndw);
		ui->dw_cou_ne->setDisabled(true);
	} else {
		set_rtdes_val(DW_COU, ndw);
		ui->dw_cou_ne->setValue(get_rtdes_val(DW_COU));
		ui->dw_cou_ne->setDisabled(false);
		set_rtdes_val(DW_COU, ndw);
	}
		he_data[currentItem]->resize(ndw);
		auto old_sz = response->datawords.size();
		response->datawords.resize(ndw);
		for (auto i = old_sz; i < ndw; i++) {
			response->datawords.at(i).init();
			reset_wgword(response->datawords.at(i), true);
		}
		ui->hexEditor->setBuffer(he_data[currentItem]->data(), ndw);
		ui->hexEditor->setCursorAtHead();
	ui->codDataEdit->setEnabled(false);
	ui->wgPwEdit->setEnabled(false);
}

uint RtWindow::legal_ndw(QTreeWidgetItem* ti)
{
	QTreeWidgetItem *p = ti->parent();
	RtResponse *r = nullptr;
	try {
		r = rbt(currentItem->data(0, Qt::UserRole).value<RtResponse>().entry_tag);
	}
	catch (...) {}
	if (!r) return 0;

	/* влияние специальных команд */
	unmuem_rt_des_t rt_des;
	rt_des.i = r->rt_des;
	if (rt_des.b.dbca) return 0;
	if (rt_des.b.lcmd_dw) return 1;

	/* Обычные установки по умолчанию */
	if (p == recvItem) return 0;
	else if (p == sendItem) return 32;
	else if (p == mc00Item || p == mc31Item)
	{
		auto tag = ti->data(0, Qt::UserRole).value<RtResponse>().entry_tag;
		return (uint)((tag & 0x0410) == 0x0410);
	}
	else return 0;
}

void RtWindow::comCfgToggled(bool s, QCheckBox *m)
{
	uint n = 0;

	if (m == ui->min_pqnr_cb) {
		printf("m_min_pqnr\n");
		m_min_pqnr = n = s ? conf().common.min_pqnr : rtc->min_pqnr;
		ui->min_pqnr_sb->setValue(0.25 * n);
	} else if (m == ui->resp_tout_cb) {
		printf("resp_tout\n");
		resp_tout = n = s ? conf().common.resp_tout : rtc->resp_tout;
		ui->resp_tout_sb->setValue(n);
	}

	rtc->set_modified();
}

void RtWindow::cfg_loaded(bool s)
{
	printf("cfg_loaded(%s)\n", s ? "true" : "false");
}

void RtWindow::comstartStateChanged(int state)
{
	rtc->common_start = (state == Qt::Checked);
	rtc->set_modified();
}

void RtWindow::dbca_bcstart_toggled(bool s)
{
	set_rtdes_val(DBCA_BCSTART, s);
	printf("RtWindow::dbca_bcstart_toggled TOGGLED\n");
}

void RtWindow::sw_dis_toggled(bool s)
{
	printf("sw_dis_toggled(%d)\n", s);
	//???
	/*
	ui->com_illegal_cb->setDisabled(s);
	ui->wrong_ch_cb->setDisabled(s);
	if (!ui->com_illegal_cb->isChecked()) {
		int t = get_rtdes_val(COM_ILLEGAL);
		ci_toggled(s);
		set_rtdes_val(COM_ILLEGAL, t);
	}
	*/
	set_rtdes_val(SW_DIS, s);
	enable_rt_des_widgets();
}

void RtWindow::dbca_toggled(bool s)
{
	set_rtdes_val(DBCA, s);
	if (!s) 
	{
		set_rtdes_val(DBCA_BCSTART, 0);
		ui->dbca_bcstart_cb->setChecked(false);
	}
	
	bool force_def_dw = get_rtdes_val(LCMD_DW) || get_rtdes_val(DBCA);
	if (s || force_def_dw)
	{
		ui->dw_cou_cb->setChecked(true);
		ui->dw_cou_cb->setEnabled(!force_def_dw);
	}
	else
	{
		ui->dw_cou_cb->setEnabled(true);
	}
	dw_cou_cb_toggled(ui->dw_cou_cb->isChecked());

	enable_rt_des_widgets();
}

void RtWindow::lcmd_dw_toggled(bool s)
{
	set_rtdes_val(LCMD_DW, s);

	bool force_def_dw = get_rtdes_val(LCMD_DW) || get_rtdes_val(DBCA);
	if (s || force_def_dw)
	{
		ui->dw_cou_cb->setChecked(true);
		ui->dw_cou_cb->setEnabled(!force_def_dw);
		ui->wa_cb->setChecked(false);
	}
	else
	{
		ui->dw_cou_cb->setEnabled(true);
	}
	dw_cou_cb_toggled(ui->dw_cou_cb->isChecked());

	enable_rt_des_widgets();
}

void RtWindow::ci_toggled(bool s)
{
	RtResponse r = currentItem->data(0, Qt::UserRole).value<RtResponse>();
	enable_rt_des_widgets();
	set_rtdes_val(COM_ILLEGAL, s);
	printf("set_rtdes_val(COM_ILLEGAL, %d)\n", s);
}

void RtWindow::wa_toggled(bool s)
{
	set_rtdes_val(WA, s);
	enable_rt_des_widgets();
	bool brwarx = s && ui->brwarx_cb->isVisible();
	set_rtdes_val(BRWARX, brwarx);
	ui->brwarx_cb->setChecked(brwarx);
}

void RtWindow::brwarx_toggled(bool s)
{
	set_rtdes_val(BRWARX, s);
}

void RtWindow::enable_rt_des_widgets()
{
	ui->sw_dis_cb->setEnabled(true);
	bool sw_dis = ui->sw_dis_cb->isChecked();
	ui->dbca_cb->setEnabled(!sw_dis);
	bool dbca = ui->dbca_cb->isChecked();
	ui->dbca_bcstart_cb->setEnabled(!sw_dis && dbca);
	ui->com_illegal_cb->setEnabled(!sw_dis);
	ui->lcmd_dw_cb->setEnabled(!sw_dis && !dbca);
	ui->n_swb_sav_cb->setEnabled(!sw_dis);
	ui->wrong_ch_cb->setEnabled(!sw_dis);
	auto p = currentItem->parent();
	bool is_mc = p == mc00Item || p == mc31Item;
	bool is_rx = p == recvItem;
	ui->legal_table_gb->setEnabled(!sw_dis && !ui->com_illegal_cb->isChecked() && !is_mc);
	ui->wa_cb->setVisible(!is_mc);
	ui->wa_cb->setEnabled(!sw_dis && !dbca && !ui->lcmd_dw_cb->isChecked() && !is_mc);
	ui->brwarx_cb->setVisible(is_rx);
	ui->brwarx_cb->setEnabled(ui->wa_cb->isChecked() && !sw_dis);
}

void RtWindow::move_MCs(QTreeWidgetItem *dest, QTreeWidgetItem *src)
{
	int n = src->childCount();
	for (int i = 0; i < n - 1; i++) {
		QTreeWidgetItem *child = src->takeChild(0);
		if (child)
			dest->insertChild(i, child);
	}
}

void RtWindow::cbDiffer0031Toggled(bool s)
{
	rtc->differ00and31mc = s;
	mc31Item->setHidden(!s);

	if (s) {
		bool is_response = (currentItem && currentItem->childCount() == 0);
		unsigned int dw_size = 0;
		DataWords* words = NULL;

		DlgNewNavItem *dlg = new DlgNewNavItem(this);;
		mc00Item->setText(0, "КУ для подадреса 0");
		try {
			for (int i = 0; i < mc00Item->childCount() - 1; i++) {
				RtResponse r = mc00Item->child(i)->data(0, Qt::UserRole).value<RtResponse>();
				if (is_response)
					dw_size = rbt(r.entry_tag)->datawords.size();
				printf("dw_size = %u\n", dw_size);
				word orig_tag = r.entry_tag;
				word new_tag = CW((r.entry_tag >> 11) & 0x1f, (r.entry_tag >> 10) & 0x1, 31, r.entry_tag & 0x1f);
				r.entry_tag = new_tag;
				QTreeWidgetItem* item = new QTreeWidgetItem((QTreeWidgetItem *)NULL, QStringList(QString("%1-%2-%3-%4 %5")
						.arg(acw(new_tag).rt).arg(acw(new_tag).tx).arg(acw(new_tag).sa).arg(acw(new_tag).ndw).arg(dlg->getGOSTString(r.entry_tag))));
				item->setToolTip(0, item->text(0));
				r.datawords.resize(dw_size);
				item->setData(0, Qt::UserRole, QVariant(QVariant::fromValue(r)));

				mc31Item->insertChild(i, item);
				if (rtc->mc31responsies == nullptr) {
					rtc->mc31responsies = new uem::device::RtResponseTable;
					rtc->mc31responsies->init();
				}
				rtc->mc31responsies->data.push_back(new RtResponse(r));
				if (is_response) {
					words = new DataWords(dw_size);
					if (rbt(new_tag, item)->datawords.size() != rbt(orig_tag)->datawords.size()) {
						rbt(new_tag, item)->datawords.resize(dw_size);
					}
					printf("LOADING DATA to item = %p", (void *)item);
					if (words->data()) {
						for (unsigned int j = 0; j < dw_size; j++) {
							rbt(new_tag, item)->datawords.at(j) = rbt(orig_tag)->datawords.at(j);
							r.datawords.at(j) = rbt(orig_tag)->datawords.at(j);
							words->data()[j] = rbt(orig_tag)->datawords.at(j).cod_data_s().b.wb;
						}
					}
				}
				he_data[item] = words;
			}
		} catch (rt_exception e) {
			QMessageBox::critical(this, "Error", e.what());
			return;
		}
		delete dlg;
	} else {
		QTreeWidgetItem *tmp;
		mc00Item->setText(0, "КУ для подадресов 0 и 31");
		while (mc31Item->childCount() > 1) {
			tmp = mc31Item->takeChild(0);
			delete he_data[tmp];
			delete tmp;
		}
		if (rtc->mc31responsies != nullptr) {
			delete rtc->mc31responsies;
			rtc->mc31responsies = nullptr;
		}
	}
	rtc->set_modified();
}

void RtWindow::rtNumChanged(int n)
{
	if (n != rtc->rtNumber()) {
		if (dev().existsRtNumber(n)) {
			QMessageBox::critical(this, "Неудача", "ОУ с таким номером уже есть", QMessageBox::Ok, QMessageBox::Ok);
			uitp->rtnr_edt->setValue(rtc->rtNumber());
			return;
		}
		int old_n = rtc->rtNumber();
		printf("selected RT #%d\n", n);
		setWindowTitle("ОУ " + QString::number(n));
		rootItem->setText(0, "ОУ " + QString::number(n));
		rtc->RT_Number = n;
		update_rtnr_2(old_n, n);
		rtc->emit_rtNumberChanged();
		rtc->set_modified();
	}
}

unsigned int RtWindow::min_pqnr()
{
	return m_min_pqnr;
}

unsigned int RtWindow::min_silence()
{
	return m_min_pqnr > 8? m_min_pqnr - 8 : 0;
}

unsigned int RtWindow::set_silence()
{
	unsigned int silence = rtc->resp_pause;
	if (silence > 8) silence -= 8; else silence = 0;
	return silence; 
}

void RtWindow::prepareNewConfig()
{

	ViUInt16 pqnr = conf().common.min_pqnr; // не менее значения, указанного в общей конфигурации
	if (pqnr < 6*4) pqnr = 6*4; // не менее 6 мкс
	if (rtc->resp_pause < pqnr)
	{
		rtc->resp_pause = pqnr;
		rtc->set_modified();
		ui->pause_set_sb->setValue(0.25 * pqnr);
	}
}

void RtWindow::updateGUI()
{
	QTreeWidgetItem *item;
	RtResponse r;
	int sa = -1;

	mc_dis_state = conf().common.mc_dis;
	ui->cbDiffer0031->setEnabled(!mc_dis_state);
	rt_brcst_dis = conf().common.rt_brcst_dis;
	if (rtc->min_pqnr_common)
		m_min_pqnr = conf().common.min_pqnr;
	else
		m_min_pqnr = rtc->min_pqnr;
	ui->min_pqnr_cb->setChecked(rtc->min_pqnr_common);

	if (rtc->resp_tout_common)
		resp_tout = conf().common.resp_tout;
	else
		resp_tout = rtc->resp_tout;
	ui->resp_tout_cb->setChecked(rtc->resp_tout_common);

	ui->min_pqnr_sb->setValue(0.25 * m_min_pqnr);
	ui->resp_tout_sb->setValue(resp_tout);

	printf("mc_dis_state = %d\n", mc_dis_state);
	mc00Item->setHidden(mc_dis_state);
	if (rtc->differ00and31mc) {
		mc31Item->setHidden(mc_dis_state);
		printf("DIFFER MC0n31\n");
	}
	for (int k = 0; k < 2; k++) {
		for (int i = 0; i < rootItem->child(k)->childCount() - 1; i++) {
			item = rootItem->child(k)->child(i);
			r = item->data(0, Qt::UserRole).value<RtResponse>();
			printf("entry_tagg = %X\n", r.entry_tag);
			sa = (r.entry_tag >> 5) & 0x1f;
			if ((sa == 0) || (sa == 31))
				item->setHidden(!mc_dis_state);
		}
	}
	printf("min_pqnr = %f\n", m_min_pqnr * 0.25);
	printf("resp_tout = %u\n", resp_tout);

	uitp->rtnr_edt->setMaxValue(rt_brcst_dis ? 31 : 30);

	rtc->set_modified();
}

void RtWindow::setAllPause()
{
	rtc->resp_pause = ui->pause_set_sb->value()  * 4;
	unsigned int silence = set_silence();
	for (uint i = 0; i < rtc->responsies.data.size(); i++)
	{
		rtc->responsies.data[i]->statusword.wg_pw_s().b.gap = silence;
	}
	for (uint i = 0; i < rtc->mc00responsies.data.size(); i++)
	{
		rtc->mc00responsies.data[i]->statusword.wg_pw_s().b.gap = silence;
	}
	if (rtc->mc31responsies)
	for (uint i = 0; i < rtc->mc31responsies->data.size(); i++)
	{
		rtc->mc31responsies->data[i]->statusword.wg_pw_s().b.gap = silence;
	}
	rtc->set_modified();
	if (currentItem && edit_sw)
	{
		RtResponse cr = currentItem->data(0, Qt::UserRole).value<RtResponse>();
		RtResponse *r = rbt(cr.entry_tag);
		if (r)
		{
			ViUInt32 wg_pw = r->statusword.wg_pw;
			ui->wgPwEdit->setValue(wg_pw);
			wgPwChanged(wg_pw);
		}
	}
}


void RtWindow::pause_set_btn_clicked()
{
	PauseSetDialog *d = new PauseSetDialog(this);
	d->pause_set_sb->setValue(ui->pause_set_sb->value());
	QPoint P = ui->pause_set_btn->mapToGlobal(QPoint(0,0));
	P += QPoint(ui->pause_set_btn->width(), -4);
	//d->show();
	//P -= QPoint(d->frameGeometry().width(), d->frameGeometry().height());
	P -= QPoint(d->width()+8, d->height()+28);
	d->move(P);
	if (d->exec() == QDialog::Accepted)
	{
		if (ui->pause_set_sb->value() != d->pause_set_sb->value())
		{
			ui->pause_set_sb->setValue(d->pause_set_sb->value());
			setAllPause();
		}
	}
	delete d;
}

