#include <stdio.h>
#include <stdlib.h>
#ifdef WIN32
#include <Windows.h>
#else
#include <pthread.h>
#include <unistd.h>
#endif
#include "linux-wrappers.h"

#define MAGIC 555

#if defined(__linux__)
#define LPDWORD uint32_t*
#define PASSED "\033[01;32mPASSED\033[0m"
#define FAILED "\033[01;31mFAILED\033[0m"
#else
#undef FAILED
#define PASSED "PASSED"
#define FAILED "FAILED"
#define usleep(x) Sleep(x/1000)
#endif

#if defined(__linux__)
void*
#else
DWORD WINAPI
#endif
thread_fn(void *arg)
{
	int i;
	long int ret = 0;

	for (i = 0; i < 5; i++) {
		printf("%s-%d\n", (char *)arg, i);

		usleep(500000);
	}
	ret = MAGIC;
#if defined(__linux__)
	pthread_exit((void *)ret);
#else
	ExitThread(ret);
#endif
}

#if defined(__linux__)
void show_priority(struct sched_param param, int policy)
{
	printf("\tsheduling = %s\n\tpriority = %d\n",
			policy == SCHED_FIFO ? "SCHED_FIFO" :
			policy == SCHED_RR ? "SCHED_RR" :
			policy == SCHED_OTHER ? "SCHED_OTHER" : "N/A", param.sched_priority);
}
#endif

int main()
{
#if defined(__linux__)
	struct sched_param param;
	HANDLE self = 0;
#endif
	HANDLE thread = 0;
	int excode;
	const char *test_str = "thread_test_str";
	int policy, new_policy;
	int ret = 1, ec_ret = 1;

	thread = CreateThread(NULL, NULL, thread_fn, const_cast<char *>(test_str), 0, NULL);
	Sleep(10);
	printf("CreateThread test %s\n", thread ? PASSED : FAILED);
	if (!thread)
		return 1;
	ret = 1;
#if defined (__linux__)
	printf("priority:\n");
	pthread_getschedparam(thread, &policy, &param);
	new_policy = policy;
	show_priority(param, policy);
	printf("new priority:\n");
#endif
	if (ret &= SetThreadPriority(thread, THREAD_PRIORITY_TIME_CRITICAL)) {
#if defined (__linux__)
		pthread_getschedparam(thread, &new_policy, &param);
		show_priority(param, new_policy);
#endif
	} else {
		printf("error: priority is NOT set.\n");
	}
#if defined (__linux__)
	printf("SetThreadPriority test %s\n", (policy != new_policy || policy == SCHED_FIFO
				|| policy == SCHED_RR) ? PASSED : FAILED);
#endif
	ec_ret &= GetExitCodeThread(thread, (LPDWORD)&excode);
	printf("excode = %s (%d), ret = %d\n", excode == STILL_ACTIVE ? "STILL_ACTIVE" : "unknown", excode, ret);
#if defined (__linux__)
	pthread_join(thread, (void **)&excode);
#else
	WaitForSingleObject(thread, INFINITE);
	ec_ret &= GetExitCodeThread(thread, (LPDWORD)&excode);
#endif
	printf("excode = %s (%d), ret = %d\n", excode == STILL_ACTIVE ? "STILL_ACTIVE" : "unknown", excode, ret);
	ret &= ec_ret;
	printf("GetExitCodeThread exit code test %s\n", ((bool)ec_ret == true) && (excode == MAGIC) ? PASSED : FAILED);
#if defined(__linux__)
	ret = !ret;
#endif

	return ret;
}
