#define _GNU_SOURCE
#define _POSIX_C_SOURCE 199309L
#include <stdio.h>
#include <string.h>
#include <termios.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <sys/time.h>
#include <pthread.h>
#include <stdlib.h>
#include <errno.h>
#include "linux-wrappers.h"

int Sleep(long msec)
{
	struct timespec ts;
	int res;

	if (msec < 0) {
		errno = EINVAL;
		return -1;
	}

	ts.tv_sec = msec / 1000;
	ts.tv_nsec = (msec % 1000) * 1000000;

	do
		res = nanosleep(&ts, &ts);
	while (res && errno == EINTR);

	return res;
}

HANDLE CreateThread(void *arg1, void *arg2,
						void *(*fn) (void *), void *fn_arg,
						int arg5, void *arg6)
{
	HANDLE thread = 0;
	int ret;

	ret = pthread_create(&thread, NULL, fn, fn_arg);
	if (ret)
		fprintf(stderr, "pthread_create error %d", ret);

	return thread;
}

bool SetThreadPriority(HANDLE thread, int prio) // argument prio is unused
{
	struct sched_param param;
	int policy = SCHED_FIFO;
	int ret;

	if ((ret = pthread_getschedparam(thread, &policy, &param))) {
		fprintf(stderr, "error: cannot get schedparam, ret = %d, errno = %d\n", ret, errno);
		return false;
	}

	policy = SCHED_FIFO;
	param.sched_priority = sched_get_priority_max(policy);
	if (pthread_setschedparam(thread, policy, &param)) {
		fprintf(stderr, "error: cannot set schedparam, ret = %d, errno = %d\n", ret, errno);
		return false;
	}

	return true;
}

bool GetExitCodeThread(HANDLE thread, uint32_t *excode)
{
	bool bret = true;
	int ret;

	ret = pthread_tryjoin_np(thread, (void **)excode);

	if (ret == EBUSY)
		*excode = STILL_ACTIVE;
	else if (ret)
		bret = false;

	return bret;
}

bool CloseHandle(HANDLE h)
{
    // Something to do?
    return true;
}

uint32_t GetTickCount()
{
	uint32_t tick;
	struct timespec ts;

	clock_gettime(CLOCK_MONOTONIC, &ts);
	tick  = ts.tv_nsec / 1000000;
	tick += ts.tv_sec * 1000;

	return tick;
}

uint32_t timeGetTime()
{
	struct timeval tv;

	gettimeofday(&tv, NULL);
	return tv.tv_sec * 1000 + tv.tv_usec / 1000;
}

int _kbhit()
{
	static int initialized = 0;
	static struct termios termios_old;
	struct termios termios;
	int bytes_left;

	if (!initialized) {
		tcgetattr(STDIN_FILENO, &termios_old);
		memcpy(&termios, &termios_old, sizeof(struct termios));
		termios.c_lflag &= ~(ICANON | ECHO);
		termios.c_lflag &= ~(INLCR | ICRNL | IXON | IXOFF);
		termios.c_cflag &= ~(PARENB);
		termios.c_cflag = (termios.c_cflag & ~CSIZE) | CS8;
		termios.c_cc[VMIN] = 1;
		tcsetattr(STDIN_FILENO, TCSANOW, &termios);
		initialized = 1;
	}
	ioctl(STDIN_FILENO, FIONREAD, &bytes_left);
	if (bytes_left) {
		tcsetattr(STDIN_FILENO, TCSAFLUSH, &termios_old);
		initialized = 0;
	}
	return bytes_left;
}

int _getch(void)
{
	int buf = 0;
	struct termios termios_old = { 0 };

	fflush(stdout);
	tcgetattr(STDIN_FILENO, &termios_old);
	termios_old.c_lflag &= ~ICANON;
	termios_old.c_lflag &= ~ECHO;
	termios_old.c_cc[VMIN] = 1;
	termios_old.c_cc[VTIME] = 0;
	tcsetattr(STDIN_FILENO, TCSANOW, &termios_old);
	read(STDIN_FILENO, &buf, 4);
	termios_old.c_lflag |= ICANON;
	termios_old.c_lflag |= ECHO;
	tcsetattr(STDIN_FILENO, TCSADRAIN, &termios_old);

	return buf;
}

int getch()
{
	return _getch();
}
